/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.expression.ExprNodeVariableVisitor;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.ExpressionWindowView;
import com.espertech.esper.view.window.IStreamRandomAccess;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class ExpressionWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private EventType eventType;
    protected ExprNode expiryExpression;
    protected MapEventBean builtinMapBean;
    protected Set<String> variableNames;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        if (expressionParameters.size() != 1) {
            String errorMessage = "Expression window view requires a single expression as a parameter";
            throw new ViewParameterException(errorMessage);
        }
        this.expiryExpression = expressionParameters.get(0);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
        LinkedHashMap<String, Object> builtinTypeDef = new LinkedHashMap<String, Object>();
        builtinTypeDef.put("current_count", Integer.class);
        builtinTypeDef.put("oldest_timestamp", Long.class);
        builtinTypeDef.put("newest_timestamp", Long.class);
        builtinTypeDef.put("expired_count", Integer.class);
        builtinTypeDef.put("view_reference", Object.class);
        EventType builtinMapType = statementContext.getEventAdapterService().createAnonymousMapType(statementContext.getStatementId() + "_exprview", builtinTypeDef);
        this.builtinMapBean = new MapEventBean(new HashMap<String, Object>(), builtinMapType);
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{this.eventType, builtinMapType}, new String[2], new boolean[2], statementContext.getEngineURI(), false);
        this.expiryExpression = ViewFactorySupport.validateExpr(statementContext, this.expiryExpression, streamTypeService, 0);
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        this.expiryExpression.accept(summaryVisitor);
        if (summaryVisitor.isHasAggregation() || summaryVisitor.isHasSubselect() || summaryVisitor.isHasStreamSelect() || summaryVisitor.isHasPreviousPrior()) {
            throw new ViewParameterException("Invalid expiry expression: Aggregation, sub-select, previous or prior functions are not supported in this context");
        }
        Class returnType = this.expiryExpression.getExprEvaluator().getType();
        if (JavaClassHelper.getBoxedType(returnType) != Boolean.class) {
            throw new ViewParameterException("Invalid return value for expiry expression, expected a boolean return value but received " + JavaClassHelper.getParameterAsString(returnType));
        }
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor();
        this.expiryExpression.accept(visitor);
        this.variableNames = visitor.getVariableNames();
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRandomAccess randomAccess = ViewServiceHelper.getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        return new ExpressionWindowView(this, randomAccess, this.expiryExpression.getExprEvaluator(), this.builtinMapBean, this.variableNames, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }
}

