/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.FirstLengthWindowViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class FirstLengthWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final FirstLengthWindowViewFactory lengthFirstFactory;
    private final int size;
    private LinkedHashSet<EventBean> indexedEvents;

    public FirstLengthWindowView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, FirstLengthWindowViewFactory lengthFirstWindowViewFactory, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.lengthFirstFactory = lengthFirstWindowViewFactory;
        this.size = size;
        this.indexedEvents = new LinkedHashSet();
    }

    @Override
    public View cloneView() {
        return this.lengthFirstFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection newDataToPost = null;
        OneEventCollection oldDataToPost = null;
        if (newData != null) {
            for (EventBean aNewData : newData) {
                if (this.indexedEvents.size() >= this.size) continue;
                if (newDataToPost == null) {
                    newDataToPost = new OneEventCollection();
                }
                newDataToPost.add(aNewData);
                this.indexedEvents.add(aNewData);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                boolean removed = this.indexedEvents.remove(anOldData);
                if (!removed) continue;
                if (oldDataToPost == null) {
                    oldDataToPost = new OneEventCollection();
                }
                oldDataToPost.add(anOldData);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            this.updateChildren(newDataToPost != null ? newDataToPost.toArray() : null, oldDataToPost != null ? oldDataToPost.toArray() : null);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

