/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.AsymetricDataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.FirstLengthWindowView;
import java.util.List;

public class FirstLengthWindowViewFactory
implements AsymetricDataWindowViewFactory {
    protected int size;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Length first window view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Length first window view requires an integer-type size parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number numParam = (Number)parameter;
        if (JavaClassHelper.isFloatingPointNumber(numParam) || numParam instanceof Long) {
            throw new ViewParameterException(errorMessage);
        }
        this.size = numParam.intValue();
        if (this.size <= 0) {
            throw new ViewParameterException("Length window requires a positive number");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new FirstLengthWindowView(agentInstanceViewFactoryContext, this, this.size);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof FirstLengthWindowView)) {
            return false;
        }
        FirstLengthWindowView myView = (FirstLengthWindowView)view;
        if (myView.getSize() != this.size) {
            return false;
        }
        return myView.isEmpty();
    }
}

