/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.FirstTimeViewFactory;
import com.espertech.esper.view.window.TimeBatchViewRStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FirstTimeView
extends ViewSupport
implements CloneableView,
StoppableView,
DataWindowView,
StopCallback {
    private final FirstTimeViewFactory timeFirstViewFactory;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final long msecIntervalSize;
    private final ScheduleSlot scheduleSlot;
    private EPStatementHandleCallback handle;
    private LinkedHashSet<EventBean> events = new LinkedHashSet();
    private boolean isClosed;
    private static final Log log = LogFactory.getLog(TimeBatchViewRStream.class);

    public FirstTimeView(FirstTimeViewFactory timeFirstViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, long msecIntervalSize) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeFirstViewFactory = timeFirstViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.scheduleCallback();
        agentInstanceContext.getTerminationCallbacks().add(this);
    }

    @Override
    public View cloneView() {
        return this.timeFirstViewFactory.makeView(this.agentInstanceContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection oldDataToPost = null;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                boolean removed = this.events.remove(anOldData);
                if (!removed) continue;
                if (oldDataToPost == null) {
                    oldDataToPost = new OneEventCollection();
                }
                oldDataToPost.add(anOldData);
            }
        }
        OneEventCollection newDataToPost = null;
        if (!this.isClosed && newData != null) {
            for (EventBean aNewData : newData) {
                this.events.add(aNewData);
                if (newDataToPost == null) {
                    newDataToPost = new OneEventCollection();
                }
                newDataToPost.add(aNewData);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            this.updateChildren(newDataToPost != null ? newDataToPost.toArray() : null, oldDataToPost != null ? oldDataToPost.toArray() : null);
        }
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    private void scheduleCallback() {
        long afterMSec = this.msecIntervalSize;
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                FirstTimeView.this.isClosed = true;
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(afterMSec, (ScheduleHandle)this.handle, this.scheduleSlot);
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.getTerminationCallbacks().remove(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

