/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.IStreamRandomAccess;
import com.espertech.esper.view.window.LengthWindowView;
import com.espertech.esper.view.window.LengthWindowViewRStream;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class LengthWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    protected int size;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Length window view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Length window view requires a single integer-type parameter";
        if (viewParameters.size() != 1) {
            throw new ViewParameterException(errorMessage);
        }
        Object parameter = viewParameters.get(0);
        if (!(parameter instanceof Number)) {
            throw new ViewParameterException(errorMessage);
        }
        Number numParam = (Number)parameter;
        if (JavaClassHelper.isFloatingPointNumber(numParam) || numParam instanceof Long) {
            throw new ViewParameterException(errorMessage);
        }
        this.size = numParam.intValue();
        if (this.size <= 0) {
            throw new ViewParameterException("Length window requires a positive number");
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRandomAccess randomAccess = ViewServiceHelper.getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        if (agentInstanceViewFactoryContext.isRemoveStream()) {
            return new LengthWindowViewRStream(agentInstanceViewFactoryContext, this, this.size);
        }
        return new LengthWindowView(agentInstanceViewFactoryContext, this, this.size, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof LengthWindowView)) {
            return false;
        }
        LengthWindowView myView = (LengthWindowView)view;
        if (myView.getSize() != this.size) {
            return false;
        }
        return myView.isEmpty();
    }
}

