/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.LengthWindowViewFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class LengthWindowViewRStream
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final LengthWindowViewFactory lengthWindowViewFactory;
    private final int size;
    private LinkedHashSet<EventBean> indexedEvents;

    public LengthWindowViewRStream(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, LengthWindowViewFactory lengthWindowViewFactory, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.lengthWindowViewFactory = lengthWindowViewFactory;
        this.size = size;
        this.indexedEvents = new LinkedHashSet();
    }

    @Override
    public View cloneView() {
        return this.lengthWindowViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            this.indexedEvents.addAll(Arrays.asList(newData));
        }
        EventBean[] expiredArr = null;
        int expiredCount = this.indexedEvents.size() - this.size;
        if (expiredCount > 0) {
            expiredArr = new EventBean[expiredCount];
            Iterator it = this.indexedEvents.iterator();
            for (int i = 0; i < expiredCount; ++i) {
                expiredArr[i] = (EventBean)it.next();
            }
            for (EventBean anExpired : expiredArr) {
                this.indexedEvents.remove(anExpired);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
            }
            if (expiredArr == null) {
                expiredArr = oldData;
            } else {
                HashSet<EventBean> oldDataSet = new HashSet<EventBean>();
                oldDataSet.addAll(Arrays.asList(expiredArr));
                oldDataSet.addAll(Arrays.asList(oldData));
                expiredArr = oldDataSet.toArray(new EventBean[oldDataSet.size()]);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }
}

