/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeAccumViewFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimeAccumView
extends ViewSupport
implements CloneableView,
DataWindowView,
StoppableView,
StopCallback {
    private final TimeAccumViewFactory factory;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final long msecIntervalSize;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ScheduleSlot scheduleSlot;
    private ArrayList<EventBean> currentBatch = new ArrayList();
    private long callbackScheduledTime;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(TimeAccumView.class);

    public TimeAccumView(TimeAccumViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, long msecIntervalSize, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.factory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeAccumView.this.sendRemoveStream();
            }
        };
        this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        agentInstanceContext.getTerminationCallbacks().add(this);
    }

    @Override
    public View cloneView() {
        return this.factory.makeView(this.agentInstanceContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null || newData.length == 0) {
            return;
        }
        boolean removeSchedule = false;
        boolean addSchedule = false;
        long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (!this.currentBatch.isEmpty()) {
            long callbackTime = timestamp + this.msecIntervalSize;
            if (callbackTime != this.callbackScheduledTime) {
                removeSchedule = true;
                addSchedule = true;
            }
        } else {
            addSchedule = true;
        }
        if (removeSchedule) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
        if (addSchedule) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(this.msecIntervalSize, (ScheduleHandle)this.handle, this.scheduleSlot);
            this.callbackScheduledTime = this.msecIntervalSize + timestamp;
        }
        this.currentBatch.addAll(Arrays.asList(newData));
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, null);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, null);
        }
    }

    protected final void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (this.hasViews()) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            if (oldData != null) {
                this.updateChildren(null, oldData);
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.getTerminationCallbacks().remove(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

