/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeBatchViewFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimeBatchView
extends ViewSupport
implements CloneableView,
StoppableView,
StopCallback,
DataWindowView {
    private final TimeBatchViewFactory timeBatchViewFactory;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final long msecIntervalSize;
    private final Long initialReferencePoint;
    private final boolean isForceOutput;
    private final boolean isStartEager;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ScheduleSlot scheduleSlot;
    private EPStatementHandleCallback handle;
    private Long currentReferencePoint;
    private LinkedList<EventBean> lastBatch = null;
    private LinkedList<EventBean> currentBatch = new LinkedList();
    private boolean isCallbackScheduled;
    private static final Log log = LogFactory.getLog(TimeBatchView.class);

    public TimeBatchView(TimeBatchViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, long msecIntervalSize, Long referencePoint, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeBatchViewFactory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.initialReferencePoint = referencePoint;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartEager) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            }
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        agentInstanceContext.getTerminationCallbacks().add(this);
    }

    @Override
    public View cloneView() {
        return this.timeBatchViewFactory.makeView(this.agentInstanceContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public final Long getInitialReferencePoint() {
        return this.initialReferencePoint;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null || newData.length == 0) {
            return;
        }
        if (this.currentBatch.isEmpty()) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = this.initialReferencePoint;
                if (this.currentReferencePoint == null) {
                    this.currentReferencePoint = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                }
            }
            if (!this.isCallbackScheduled) {
                this.scheduleCallback();
                this.isCallbackScheduled = true;
            }
        }
        this.currentBatch.addAll(Arrays.asList(newData));
    }

    protected final void sendBatch() {
        this.isCallbackScheduled = false;
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new LinkedList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize + " initialReferencePoint=" + this.initialReferencePoint;
    }

    private void scheduleCallback() {
        long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long afterMSec = TimeBatchView.computeWaitMSec(current, this.currentReferencePoint, this.msecIntervalSize);
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeBatchView.this.sendBatch();
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(afterMSec, (ScheduleHandle)this.handle, this.scheduleSlot);
    }

    protected static long computeWaitMSec(long current, long reference, long interval) {
        long solution;
        long n = (current - reference) / interval;
        if (reference > current) {
            --n;
        }
        if ((solution = reference + (n + 1L) * interval - current) == 0L) {
            return interval;
        }
        return solution;
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.getTerminationCallbacks().remove(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

