/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeLengthBatchViewFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimeLengthBatchView
extends ViewSupport
implements CloneableView,
StoppableView,
StopCallback,
DataWindowView {
    private static final Log log = LogFactory.getLog(TimeLengthBatchView.class);
    private final TimeLengthBatchViewFactory timeLengthBatchViewFactory;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final long msecIntervalSize;
    private final long numberOfEvents;
    private final boolean isForceOutput;
    private final boolean isStartEager;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final ScheduleSlot scheduleSlot;
    private ArrayList<EventBean> lastBatch = null;
    private ArrayList<EventBean> currentBatch = new ArrayList();
    private boolean isCallbackScheduled;
    private EPStatementHandleCallback handle;

    public TimeLengthBatchView(TimeLengthBatchViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, long msecIntervalSize, long numberOfEvents, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeLengthBatchViewFactory = timeBatchViewFactory;
        this.msecIntervalSize = msecIntervalSize;
        this.numberOfEvents = numberOfEvents;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartEager) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        agentInstanceContext.getTerminationCallbacks().add(this);
    }

    @Override
    public View cloneView() {
        return this.timeLengthBatchViewFactory.makeView(this.agentInstanceContext);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                this.currentBatch.remove(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        this.currentBatch.addAll(Arrays.asList(newData));
        if ((long)this.currentBatch.size() < this.numberOfEvents) {
            if (!this.isCallbackScheduled) {
                this.scheduleCallback();
                this.isCallbackScheduled = true;
            }
            return;
        }
        this.sendBatch(false);
    }

    protected final void sendBatch(boolean isFromSchedule) {
        if (isFromSchedule) {
            this.isCallbackScheduled = false;
        } else if (this.isCallbackScheduled) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.isCallbackScheduled = false;
        }
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize + " numberOfEvents=" + this.numberOfEvents;
    }

    private void scheduleCallback() {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                TimeLengthBatchView.this.sendBatch(true);
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(this.msecIntervalSize, (ScheduleHandle)this.handle, this.scheduleSlot);
    }

    @Override
    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.getTerminationCallbacks().remove(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

