/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import com.espertech.esper.view.window.TimeBatchViewFactoryParams;
import com.espertech.esper.view.window.TimeLengthBatchView;
import java.util.List;

public class TimeLengthBatchViewFactory
extends TimeBatchViewFactoryParams
implements DataWindowViewFactory,
DataWindowViewWithPrevious,
DataWindowBatchingViewFactory {
    protected long numberOfEvents;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate("Time-length combination batch view", viewFactoryContext.getStatementContext(), expressionParameters);
        String errorMessage = "Time-length combination batch view requires a numeric or time period parameter as a time interval size, and an integer parameter as a maximal number-of-events, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (viewParameters.size() != 2 && viewParameters.size() != 3) {
            throw new ViewParameterException(errorMessage);
        }
        this.processExpiry(viewParameters.get(0), errorMessage, "Time-length-combination batch view requires a size of at least 1 msec");
        Object parameter = viewParameters.get(1);
        if (!(parameter instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)parameter)) {
            throw new ViewParameterException(errorMessage);
        }
        this.numberOfEvents = ((Number)parameter).longValue();
        if (viewParameters.size() > 2) {
            this.processKeywords(viewParameters.get(2), errorMessage);
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexMap();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamRelativeAccess relativeAccessByEvent = ViewServiceHelper.getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        return new TimeLengthBatchView(this, agentInstanceViewFactoryContext, this.millisecondsBeforeExpiry, this.numberOfEvents, this.isForceUpdate, this.isStartEager, relativeAccessByEvent);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof TimeLengthBatchView)) {
            return false;
        }
        TimeLengthBatchView myView = (TimeLengthBatchView)view;
        if (myView.getMsecIntervalSize() != this.millisecondsBeforeExpiry) {
            return false;
        }
        if (myView.getNumberOfEvents() != this.numberOfEvents) {
            return false;
        }
        if (myView.isForceOutput() != this.isForceUpdate) {
            return false;
        }
        if (myView.isStartEager()) {
            return false;
        }
        return myView.isEmpty();
    }
}

