
package org.mule.module.esper.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.esper.EsperModule;
import org.mule.module.esper.adapters.EsperModuleProcessAdapter;


/**
 * FilterMessageProcessor invokes the {@link org.mule.module.esper.EsperModule#filter(java.lang.Object, java.lang.String, java.lang.String, org.mule.api.callback.SourceCallback)} method in {@link EsperModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2-SNAPSHOT", date = "2012-11-01T08:26:45-05:00", comments = "Build master.1330.0f1ea95")
public class FilterMessageProcessor
    extends AbstractListeningMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, InterceptingMessageProcessor
{

    protected Object eventPayload;
    protected Object _eventPayloadType;
    protected Object statement;
    protected String _statementType;
    protected Object key;
    protected String _keyType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets statement
     * 
     * @param value Value to set
     */
    public void setStatement(Object value) {
        this.statement = value;
    }

    /**
     * Sets eventPayload
     * 
     * @param value Value to set
     */
    public void setEventPayload(Object value) {
        this.eventPayload = value;
    }

    /**
     * Sets key
     * 
     * @param value Value to set
     */
    public void setKey(Object value) {
        this.key = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        final SourceCallback sourceCallback = this;
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(EsperModuleProcessAdapter.class, false, event);
            final Object _transformedEventPayload = ((Object) evaluateAndTransform(getMuleContext(), event, FilterMessageProcessor.class.getDeclaredField("_eventPayloadType").getGenericType(), null, eventPayload));
            final String _transformedStatement = ((String) evaluateAndTransform(getMuleContext(), event, FilterMessageProcessor.class.getDeclaredField("_statementType").getGenericType(), null, statement));
            final String _transformedKey = ((String) evaluateAndTransform(getMuleContext(), event, FilterMessageProcessor.class.getDeclaredField("_keyType").getGenericType(), null, key));
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((EsperModule) object).filter(_transformedEventPayload, _transformedStatement, _transformedKey, sourceCallback);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("filter"), event, e);
        }
    }

}
