
package org.mule.module.esper.sources;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.source.MessageSource;
import org.mule.module.esper.EsperModule;
import org.mule.module.esper.adapters.EsperModuleProcessAdapter;
import org.mule.module.esper.processors.AbstractListeningMessageProcessor;


/**
 * ListenMessageSource wraps {@link org.mule.module.esper.EsperModule#listen(java.lang.String, org.mule.api.callback.SourceCallback)} method in {@link EsperModule } as a message source capable of generating Mule events.  The POJO's method is invoked in its own thread.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2-SNAPSHOT", date = "2012-11-01T08:26:45-05:00", comments = "Build master.1330.0f1ea95")
public class ListenMessageSource
    extends AbstractListeningMessageProcessor<Object>
    implements Runnable, FlowConstructAware, MuleContextAware, Startable, Stoppable, MessageSource
{

    protected Object statement;
    protected String _statementType;
    /**
     * Thread under which this message source will execute
     * 
     */
    private Thread thread;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    /**
     * Sets statement
     * 
     * @param value Value to set
     */
    public void setStatement(Object value) {
        this.statement = value;
    }

    /**
     * Method to be called when Mule instance gets started.
     * 
     */
    public void start()
        throws MuleException
    {
        if (thread == null) {
            thread = new Thread(this, "Receiving Thread");
        }
        thread.start();
    }

    /**
     * Method to be called when Mule instance gets stopped.
     * 
     */
    public void stop()
        throws MuleException
    {
        thread.interrupt();
    }

    /**
     * Implementation {@link Runnable#run()} that will invoke the method on the pojo that this message source wraps.
     * 
     */
    public void run() {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(EsperModuleProcessAdapter.class, false, null);
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            final SourceCallback sourceCallback = this;
            final String transformedStatement = ((String) transform(getMuleContext(), null, getClass().getDeclaredField("_statementType").getGenericType(), null, statement));
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((EsperModule) object).listen(transformedStatement, sourceCallback);
                    return null;
                }

            }
            , null, null);
        } catch (Exception e) {
            getMuleContext().getExceptionListener().handleException(e);
        }
    }

}
