/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.esper;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.UpdateListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ConnectionException;
import org.mule.api.MuleContext;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.param.Optional;
import org.mule.api.callback.SourceCallback;
import org.mule.api.context.MuleContextAware;
import org.mule.module.esper.EsperException;
import org.mule.module.esper.SourceCallbackUpdateListener;
import org.w3c.dom.Node;

@Module(name="esper", schemaVersion="1.0", poolable=false, minMuleVersion="3.3")
public class EsperModule
implements MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private EPServiceProvider esperServiceProvider;
    private MuleContext muleContext;
    private Map<String, EPStatement> filterStatements = new HashMap<String, EPStatement>();
    @Configurable
    private String configuration;

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @PostConstruct
    public void connect() throws ConnectionException {
        Configuration c = new Configuration();
        if (StringUtils.isNotBlank((String)this.configuration)) {
            this.logger.debug((Object)("Initializing EsperServiceProvider with configuration: " + this.configuration));
            URL configURL = Thread.currentThread().getContextClassLoader().getResource(this.configuration);
            c.configure(configURL);
        }
        this.esperServiceProvider = EPServiceProviderManager.getDefaultProvider((Configuration)c);
    }

    @PreDestroy
    public void disconnect() {
        this.logger.debug((Object)"Destroying EsperServiceProvider");
        this.esperServiceProvider.destroy();
    }

    @Processor(name="send")
    public void send(Object eventPayload, @Optional String eventName) {
        this.logger.debug((Object)String.format("Sending event %s to stream", eventPayload));
        if (eventPayload instanceof Map) {
            if (StringUtils.isBlank((String)eventName)) {
                throw new EsperException("event-name must be specified with map events");
            }
            this.esperServiceProvider.getEPRuntime().sendEvent((Map)eventPayload, eventName);
        } else if (eventPayload instanceof Node) {
            this.esperServiceProvider.getEPRuntime().sendEvent((Node)eventPayload);
        } else {
            this.esperServiceProvider.getEPRuntime().sendEvent(eventPayload);
        }
    }

    @Source
    public void listen(String statement, SourceCallback callback) {
        this.logger.debug((Object)("Listening for events with statement: " + statement));
        EPStatement s = this.esperServiceProvider.getEPAdministrator().createEPL(statement);
        s.addListener((UpdateListener)new SourceCallbackUpdateListener(callback));
    }

    @Processor(intercepting=true, name="filter")
    public synchronized void filter(@Optional Object eventPayload, String statement, String key, SourceCallback afterChain) {
        EPStatement filterStatement;
        this.esperServiceProvider.getEPRuntime().sendEvent(eventPayload);
        if (!this.filterStatements.containsKey(statement)) {
            filterStatement = this.esperServiceProvider.getEPAdministrator().createEPL(statement);
            this.filterStatements.put(statement, filterStatement);
        } else {
            filterStatement = this.filterStatements.get(statement);
        }
        SafeIterator safeIterator = filterStatement.safeIterator();
        try {
            Boolean result = (Boolean)((EventBean)safeIterator.next()).get(key);
            if (safeIterator.hasNext()) {
                this.logger.warn((Object)"Statement contains more then one response");
            }
            if (!result.booleanValue()) {
                this.logger.debug((Object)"Not passing message, filter expression evaluated to true");
            } else {
                afterChain.process();
            }
        }
        catch (Exception e) {
            throw new EsperException(e);
        }
        finally {
            safeIterator.close();
        }
    }

    public String getConfiguration() {
        return this.configuration;
    }
}

