/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.esper;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.callback.SourceCallback;

public class SourceCallbackUpdateListener
implements UpdateListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    SourceCallback sourceCallback;

    public SourceCallbackUpdateListener(SourceCallback sourceCallback) {
        this.sourceCallback = sourceCallback;
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (this.logger.isDebugEnabled()) {
            int newEventSize = 0;
            int oldEventSize = 0;
            if (newEvents != null) {
                newEventSize = newEvents.length;
            }
            if (oldEvents != null) {
                oldEventSize = oldEvents.length;
            }
            this.logger.debug((Object)String.format("Received %d new events and %d old events", newEventSize, oldEventSize));
        }
        if (newEvents == null) {
            this.logger.debug((Object)"Null events collection received");
            return;
        }
        for (EventBean event : newEvents) {
            try {
                this.logger.debug((Object)("Processing received event: " + event));
                this.sourceCallback.process(event.getUnderlying());
            }
            catch (Exception e) {
                this.logger.error((Object)("Could not process event: " + event), (Throwable)e);
            }
        }
    }
}

