/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.module.hubspot.exception.HubSpotConnectorAccessTokenExpiredException;
import org.mule.module.hubspot.exception.HubSpotConnectorException;
import org.mule.module.hubspot.exception.HubSpotConnectorNoAccessTokenException;
import org.mule.module.hubspot.model.OAuthCredentials;
import org.springframework.core.annotation.Order;

@Connector(name="hubspot", schemaVersion="1.0", friendlyName="HubSpot")
public class HubSpotConnector {
    private static final Log logger = LogFactory.getLog(HubSpotConnector.class);
    private static final String HUB_SPOT_URL_API = "http://hubapi.com";
    private static final String HUB_SPOT_URL_AUTH = "https://app.hubspot.com/auth/authenticate";
    private static final String PARAM_ACCESS_TOKEN = "access_token";
    private static final String API_VERSION = "v1";
    private static final Pattern PATTERN_ACCESS_TOKEN = Pattern.compile("access_token=([^&]+)&?");
    private static final Pattern PATTERN_EXPIRES_AT = Pattern.compile("expires_in=([^&]+)&?");
    private static final Pattern PATTERN_REFRESH_TOKEN = Pattern.compile("refresh_token=([^&]+)&?");
    private static final Pattern PATTERN_USERID = Pattern.compile("userid=([^&]+)&?");
    private static final Pattern PATTERN_ERROR = Pattern.compile("error=([^&]+)&?");
    @Configurable
    @Order(value=1)
    private String clientId;
    @Configurable
    @Order(value=2)
    private String hubId;
    @Configurable
    @Order(value=3)
    private String scope;
    @Configurable
    @Order(value=4)
    private String callbackUrl;
    private Map<String, OAuthCredentials> credentials;
    private Client jerseyClient;

    @PostConstruct
    public void initialize() {
        this.jerseyClient = new Client();
        this.credentials = new WeakHashMap<String, OAuthCredentials>();
    }

    @Processor
    public String authenticate(String userId, @OutboundHeaders Map<String, Object> headers) throws HubSpotConnectorException {
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_AUTH).build(new Object[0]);
        WebResource wr = this.jerseyClient.resource(uri);
        String finalCallbackUrl = this.callbackUrl + (this.callbackUrl.indexOf(63) < 0 ? "?" : "&") + "userid=" + userId;
        wr = wr.queryParam("client_id", this.clientId).queryParam("portalId", this.hubId).queryParam("redirect_uri", finalCallbackUrl).queryParam("scope", this.scope);
        String authUrl = wr.getURI().toString();
        headers.put("Location", authUrl);
        headers.put("http.status", "302");
        logger.info((Object)("Ready for authentication. Redirecting (302) to: " + authUrl));
        return authUrl;
    }

    @Processor
    public String authenticateResponse(String inputRequest) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException {
        if (StringUtils.isEmpty((String)inputRequest)) {
            throw new HubSpotConnectorException("The parameter inputRequest can not be empty");
        }
        OAuthCredentials oACreds = new OAuthCredentials();
        Matcher m = PATTERN_ERROR.matcher(inputRequest);
        if (m.find()) {
            String errDesc = m.group(1);
            if (errDesc.equals("invalid_scope")) {
                throw new HubSpotConnectorException("The configuration is requesting a scope that the service application does not have available.");
            }
            throw new HubSpotConnectorException("The service has responded with an error message: " + errDesc);
        }
        m = PATTERN_USERID.matcher(inputRequest);
        if (m.find()) {
            oACreds.setUserId(m.group(1));
        }
        if ((m = PATTERN_ACCESS_TOKEN.matcher(inputRequest)).find()) {
            oACreds.setAccessToken(m.group(1));
        }
        if ((m = PATTERN_EXPIRES_AT.matcher(inputRequest)).find()) {
            oACreds.setExpiresAt(m.group(1));
        }
        if ((m = PATTERN_REFRESH_TOKEN.matcher(inputRequest)).find()) {
            oACreds.setRefreshToken(m.group(1));
        }
        if (oACreds.getAccessToken() == null) {
            logger.error((Object)("Cannot find the access_token in the response:" + inputRequest));
            throw new HubSpotConnectorNoAccessTokenException("The response of the authentication process does not have an access token. Url:" + inputRequest);
        }
        this.credentials.put(oACreds.getUserId(), oACreds);
        logger.info((Object)("Stored credentials for user:" + oACreds.getUserId()));
        return oACreds.getUserId();
    }

    @Processor
    public boolean hasUserAccessToken(String userId) {
        return this.credentials.get(userId) != null && StringUtils.isNotEmpty((String)this.credentials.get(userId).getAccessToken());
    }

    @Processor
    public String getAllContacts(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String contactOffset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/lists/all/contacts/all").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        if (count != null) {
            wr = wr.queryParam("count", count);
        }
        if (contactOffset != null) {
            wr = wr.queryParam("vidOffset", contactOffset);
        }
        logger.info((Object)("Requesting allContacts to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getRecentContacts(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String timeOffset, @Optional @Default(value="") String contactOffset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/lists/recently_updated/contacts/recent").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        if (count != null) {
            wr = wr.queryParam("count", count);
        }
        if (timeOffset != null) {
            wr = wr.queryParam("timeOffset", timeOffset);
        }
        if (contactOffset != null) {
            wr = wr.queryParam("vidOffset", contactOffset);
        }
        logger.info((Object)("Requesting recentContacts to:" + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getContactById(String userId, String contactId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)contactId)) {
            throw new HubSpotConnectorException("The parameter contactId cannot be empty");
        }
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contact/vid/{contactid}/profile").build(new Object[]{API_VERSION, contactId});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting contactById to:" + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getContactByEmail(String userId, String contactEmail) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)contactEmail)) {
            throw new HubSpotConnectorException("The parameter contactEmail cannot be empty");
        }
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contact/email/{contactemail}/profile").build(new Object[]{API_VERSION, contactEmail});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting contactByEmail to:" + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getContactByUserToken(String userId, String contactUserToken) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)contactUserToken)) {
            throw new HubSpotConnectorException("The parameter contactUserToken cannot be empty");
        }
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contact/utk/{contactusertoken}/profile").build(new Object[]{API_VERSION, contactUserToken});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting contactByUserToken to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getContactsByQuery(String userId, String query, @Optional @Default(value="") String count) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)query)) {
            throw new HubSpotConnectorException("The parameter query cannot be empty");
        }
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/search/query").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        wr = wr.queryParam("q", query);
        if (count != null) {
            wr = wr.queryParam("count", count);
        }
        logger.info((Object)("Requesting contactsByQuery to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String deleteContact(String userId, String contactId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)contactId)) {
            throw new HubSpotConnectorException("The parameter contactId cannot be empty");
        }
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contact/vid/{contactid}").build(new Object[]{API_VERSION, contactId});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting deleteContact to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.DELETE);
        return strResponse;
    }

    @Processor
    public String updateContact(String userId, String contactId, String contactJson) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)contactId)) {
            throw new HubSpotConnectorException("The parameter contactId cannot be empty");
        }
        if (StringUtils.isEmpty((String)contactJson)) {
            throw new HubSpotConnectorException("The parameter contactJson cannot be empty");
        }
        this.checkValidJson(contactJson);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contact/vid/{contactid}/profile").build(new Object[]{API_VERSION, contactId});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting updateContact to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.POST, contactJson);
        return strResponse;
    }

    @Processor
    public String createContact(String userId, String contactJson) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        if (StringUtils.isEmpty((String)contactJson)) {
            throw new HubSpotConnectorException("The parameter contactJson cannot be empty");
        }
        this.checkValidJson(contactJson);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contact").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting createContact to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.POST, contactJson);
        return strResponse;
    }

    @Processor
    public String getContactStatistics(String userId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/contacts/statistics").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting contactStatistics to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getContactsLists(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String offset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/lists").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        if (count != null) {
            wr = wr.queryParam("count", count);
        }
        if (offset != null) {
            wr = wr.queryParam("offset", offset);
        }
        logger.info((Object)("Requesting contactsLists to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getContactListById(String userId, String listId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/lists/{listid}").build(new Object[]{API_VERSION, listId});
        WebResource wr = this.getWebResource(userId, uri);
        logger.info((Object)("Requesting contactListById to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    @Processor
    public String getDynamicContactLists(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String offset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        this.checkEmptyUserId(userId);
        URI uri = UriBuilder.fromPath((String)HUB_SPOT_URL_API).path("/contacts/{apiversion}/lists/dynamic").build(new Object[]{API_VERSION});
        WebResource wr = this.getWebResource(userId, uri);
        if (count != null) {
            wr = wr.queryParam("count", count);
        }
        if (offset != null) {
            wr = wr.queryParam("offset", offset);
        }
        logger.info((Object)("Requesting dynamicContactLists to: " + wr.toString()));
        String strResponse = this.webResourceGet(wr, userId, WebResourceMethods.GET);
        return strResponse;
    }

    private String webResourceGet(WebResource wr, String userId, WebResourceMethods method) throws HubSpotConnectorAccessTokenExpiredException, HubSpotConnectorException {
        return this.webResourceGet(wr, userId, method, null);
    }

    private String webResourceGet(WebResource wr, String userId, WebResourceMethods method, String requestBody) throws HubSpotConnectorAccessTokenExpiredException, HubSpotConnectorException {
        try {
            return this.webResourceCallByEnumType(wr, method, requestBody);
        }
        catch (UniformInterfaceException e) {
            int statusCode = e.getResponse().getStatus();
            if (statusCode == 204) {
                return "";
            }
            if (statusCode == 401) {
                throw new HubSpotConnectorAccessTokenExpiredException("The access token for the userId " + userId + "has expired", e);
            }
            throw new HubSpotConnectorException("ERROR - statusCode: " + statusCode, e);
        }
    }

    private String webResourceCallByEnumType(WebResource wr, WebResourceMethods method, String requestBody) {
        if (WebResourceMethods.GET.equals((Object)method)) {
            return (String)wr.get(String.class);
        }
        if (WebResourceMethods.POST.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).post(String.class, (Object)requestBody);
        }
        if (WebResourceMethods.PUT.equals((Object)method)) {
            return (String)wr.put(String.class);
        }
        if (WebResourceMethods.DELETE.equals((Object)method)) {
            return (String)wr.delete(String.class);
        }
        return null;
    }

    private void checkValidJson(String json) throws HubSpotConnectorException {
        try {
            JsonParser parser = new ObjectMapper().getJsonFactory().createJsonParser(json);
            while (parser.nextToken() != null) {
            }
        }
        catch (JsonParseException jpe) {
            throw new HubSpotConnectorException("The contactJson contains a JSON malformed", jpe);
        }
        catch (IOException ioe) {
            throw new HubSpotConnectorException("The contactJson cannot be readed", ioe);
        }
    }

    private WebResource getWebResource(String userId, URI uri) throws HubSpotConnectorNoAccessTokenException {
        OAuthCredentials oACreds = this.credentials.get(userId);
        if (oACreds == null) {
            throw new HubSpotConnectorNoAccessTokenException("The user with id " + userId + " does not have credentials");
        }
        return this.jerseyClient.resource(uri).queryParam(PARAM_ACCESS_TOKEN, oACreds.getAccessToken());
    }

    private void checkEmptyUserId(String userId) throws HubSpotConnectorException {
        if (StringUtils.isEmpty((String)userId)) {
            throw new HubSpotConnectorException("The parameter UserId cannot be empty");
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getHubId() {
        return this.hubId;
    }

    public void setHubId(String hubId) {
        this.hubId = hubId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public Client getJerseyClient() {
        return this.jerseyClient;
    }

    public void setJerseyClient(Client jerseyClient) {
        this.jerseyClient = jerseyClient;
    }

    private static enum WebResourceMethods {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

