/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.api.exception;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.error.JavaModuleError;
import org.mule.extensions.java.api.exception.JavaModuleException;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifierFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSuchConstructorModuleException
extends JavaModuleException {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoSuchConstructorModuleException.class);

    public NoSuchConstructorModuleException(ExecutableIdentifier id, Class<?> targetClass, Map<String, TypedValue<Object>> args) {
        super(NoSuchConstructorModuleException.buildMessage(id, targetClass, args), JavaModuleError.NO_SUCH_CONSTRUCTOR);
    }

    private static String buildMessage(ExecutableIdentifier id, Class<?> targetClass, Map<String, TypedValue<Object>> args) {
        String msg = String.format("No public Constructor found with name [%s] and arguments %s in class [%s].", id.getElementId(), NoSuchConstructorModuleException.toHumanReadableArgs(args), targetClass.getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg + " Available public Constructors are: " + Arrays.stream(targetClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).map(c -> ExecutableIdentifierFactory.create(c).getElementId()).collect(Collectors.toList()));
        }
        return msg;
    }
}

