/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.operation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchConstructorModuleException;
import org.mule.extensions.java.api.exception.NonInstantiableTypeModuleException;
import org.mule.extensions.java.internal.JavaModuleUtils;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.error.JavaNewInstanceErrorProvider;
import org.mule.extensions.java.internal.metadata.ConstructorTypeResolver;
import org.mule.extensions.java.internal.parameters.ConstructorIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;

public class JavaNewInstanceOperation {
    @Inject
    private JavaModuleLoadingCache cache;

    @Alias(value="new")
    @Throws(value={JavaNewInstanceErrorProvider.class})
    @OutputResolver(output=ConstructorTypeResolver.class)
    public Object newInstance(@ParameterGroup(name="Constructor") @MetadataKeyId(value=ConstructorTypeResolver.class) ConstructorIdentifier identifier, @Optional @NullSafe @Content @TypeResolver(value=ConstructorTypeResolver.class) Map<String, TypedValue<Object>> args) throws ClassNotFoundModuleException, NoSuchConstructorModuleException, ArgumentMismatchModuleException, InvocationModuleException, NonInstantiableTypeModuleException {
        Class<?> targetClass = this.cache.loadClass(identifier.getClazz());
        Constructor constructor = this.cache.getConstructor(identifier, targetClass, args);
        try {
            List<Object> sortedArgs = JavaModuleUtils.getSortedArgs(args, constructor.getParameters());
            if (sortedArgs.size() == constructor.getParameters().length) {
                return constructor.newInstance(sortedArgs.toArray());
            }
            throw new ArgumentMismatchModuleException(this.failureMsg(identifier), constructor, args);
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentMismatchModuleException(this.failureMsg(identifier), (Executable)constructor, args, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new NonInstantiableTypeModuleException(identifier, args, (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvocationModuleException(this.failureMsg(identifier), args, (Throwable)e);
        }
    }

    private String failureMsg(ExecutableIdentifier identifier) {
        return String.format("Failed to instantiate Class [%s]", identifier.getClazz());
    }
}

