/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.parameters;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class ExecutableIdentifier {
    private static final String METHOD_MASK = "%s(%s)";
    private static final String ARG_SEPARATOR = ",";
    private static final Pattern METHOD_MATCHER = Pattern.compile("(.+)\\((.*)\\)");

    public abstract String getClazz();

    public abstract String getElementId();

    public String getElementName() {
        Matcher match = METHOD_MATCHER.matcher(this.getElementId().trim().replaceAll(" ", ""));
        return match.matches() ? match.group(1) : "";
    }

    public abstract boolean matches(Executable var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecutableIdentifier)) {
            return false;
        }
        ExecutableIdentifier that = (ExecutableIdentifier)o;
        return this.getClazz().equals(that.getClazz()) && this.sanitize(this.getElementId()).equals(this.sanitize(that.getElementId()));
    }

    public int hashCode() {
        return this.getClazz().hashCode() * 31 + this.sanitize(this.getElementId()).hashCode();
    }

    public String toString() {
        return this.getClazz() + "::" + this.getElementId();
    }

    protected String buildId(String elementName, Class<?>[] argTypes) {
        return String.format(METHOD_MASK, elementName.trim(), Arrays.stream(argTypes).map(Class::getSimpleName).collect(Collectors.joining(ARG_SEPARATOR)));
    }

    private String sanitize(String id) {
        return id.trim().replaceAll(" ", "");
    }
}

