/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.cache;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.NoSuchConstructorModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.internal.parameters.ConstructorIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.ClassUtils;

public final class JavaModuleLoadingCache {
    private final String METHOD_IDENTIFIER = "%s#%s";
    private final Map<String, Class<?>> typesCache = new ConcurrentHashMap();
    private final Map<String, Executable> executablesCache = new ConcurrentHashMap<String, Executable>();

    public Class<?> loadClass(String className) {
        return this.typesCache.computeIfAbsent(className, key -> {
            try {
                return ClassUtils.loadClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundModuleException(e.getMessage(), e);
            }
        });
    }

    public Constructor getConstructor(ConstructorIdentifier id, Class<?> declaringClass, Map<String, TypedValue<Object>> args) {
        return (Constructor)this.executablesCache.computeIfAbsent(String.format("%s#%s", declaringClass.getName(), id.getElementId()), key -> Arrays.stream(declaringClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).filter(id::matches).findFirst().orElseThrow(() -> new NoSuchConstructorModuleException(id, declaringClass, args)));
    }

    public Method getMethod(ExecutableIdentifier id, Class<?> clazz, Map<String, TypedValue<Object>> args, boolean expectStatic) {
        return (Method)this.executablesCache.computeIfAbsent(String.format("%s#%s", clazz.getName(), id.getElementId()), key -> this.getPublicMethods(clazz, expectStatic).stream().filter(id::matches).findFirst().orElseThrow(() -> new NoSuchMethodModuleException(id, clazz, args)));
    }

    private List<Method> getPublicMethods(Class<?> clazz, boolean expectStatic) {
        return Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> expectStatic == Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
    }
}

