/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.parameters;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ConstructorIdentifier
extends ExecutableIdentifier {
    public static final String NAME = "Constructor";
    @Parameter
    @Alias(value="class")
    @ClassValue
    @MetadataKeyPart(order=1, providedByKeyResolver=false)
    @Summary(value="Fully qualified name of the Class containing the referenced Method")
    private String clazz;
    @Parameter
    @Alias(value="constructor")
    @MetadataKeyPart(order=2)
    @Summary(value="Represents the Constructor signature containing the name and it's argument types.")
    private String constructorId;

    public ConstructorIdentifier() {
    }

    public ConstructorIdentifier(Constructor constructor) {
        this(constructor.getDeclaringClass().getName(), constructor.getDeclaringClass().getSimpleName(), constructor.getParameterTypes());
    }

    public ConstructorIdentifier(String className, String constructor, Class<?>[] argTypes) {
        this.clazz = className;
        this.constructorId = this.buildId(constructor, argTypes);
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public String getElementId() {
        return this.constructorId;
    }

    @Override
    public boolean matches(Executable element) {
        return element instanceof Constructor && new ConstructorIdentifier((Constructor)element).equals(this);
    }

    @Override
    public String getExecutableTypeName() {
        return NAME;
    }
}

