/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.transformer.ParameterTransformer;
import org.mule.extensions.java.internal.transformer.ParametersTransformationResult;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.springframework.core.ResolvableType;

public final class JavaModuleUtils {
    public static final String ARG_0 = "arg0";
    public static final String ARG_PREFIX = "arg";

    private JavaModuleUtils() {
    }

    public static void validateType(String clazz, Object instance, boolean acceptSubtypes, JavaModuleLoadingCache cache) throws ClassNotFoundModuleException, WrongTypeModuleException {
        boolean isValid;
        Class<?> declaredClass = cache.loadClass(clazz);
        boolean bl = isValid = acceptSubtypes ? ClassUtils.isInstance(declaredClass, (Object)instance) : declaredClass.equals(instance.getClass());
        if (!isValid) {
            throw new WrongTypeModuleException(clazz, instance.getClass().getName());
        }
    }

    public static void logTooManyArgsWarning(Executable method, Map<String, TypedValue<Object>> args, ExecutableIdentifier identifier, Logger logger) {
        String expectedArgs = method.getParameters().length == 0 ? "No arguments were expected" : "Expected arguments are " + JavaModuleUtils.toHumanReadableArgs(method);
        logger.warn(String.format("Too many arguments were provided for the invocation of %s '%s' from Class '%s'. %s but got %s.", identifier.getExecutableTypeName(), identifier.getElementId(), identifier.getClazz(), expectedArgs, JavaModuleUtils.toHumanReadableArgs(args)));
    }

    public static ParametersTransformationResult getSortedAndTransformedArgs(Map<String, TypedValue<Object>> args, Executable executable, TransformationService transformationService, ExpressionManager expressionManager, Logger logger) {
        Parameter[] parameters = executable.getParameters();
        if (parameters.length == 0) {
            return new ParametersTransformationResult(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        boolean useCanonicalArgName = args.containsKey(ARG_0);
        ParameterTransformer parameterTransformer = new ParameterTransformer(executable, transformationService, expressionManager);
        ArrayList<Object> sortedArgs = new ArrayList<Object>(parameters.length);
        LinkedList<String> missingArgs = new LinkedList<String>();
        LinkedList<String> failedToTransformArgs = new LinkedList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            try {
                TypedValue<Object> value;
                TypedValue<Object> typedValue = value = useCanonicalArgName ? args.get(ARG_PREFIX + i) : args.get(parameter.getName());
                if (value == null) {
                    missingArgs.add(parameter.getName());
                    continue;
                }
                Object originalValue = value.getValue();
                if (parameterTransformer.parameterNeedsTransformation(originalValue, i)) {
                    Optional<Object> transformedValue = parameterTransformer.transformParameter(originalValue, i);
                    if (transformedValue.isPresent()) {
                        sortedArgs.add(transformedValue.get());
                        continue;
                    }
                    failedToTransformArgs.add(parameter.getName());
                    continue;
                }
                sortedArgs.add(originalValue);
                continue;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An unexpected error occurred while transforming the parameter '" + parameter.getName() + "'", (Throwable)e);
                }
                failedToTransformArgs.add(parameter.getName());
            }
        }
        return new ParametersTransformationResult(sortedArgs, failedToTransformArgs, missingArgs);
    }

    public static List<String> toHumanReadableArgs(Map<String, TypedValue<Object>> args) {
        return args.entrySet().stream().map(e -> ResolvableType.forType((Type)((TypedValue)e.getValue()).getDataType().getType()).toString() + " " + (String)e.getKey()).collect(Collectors.toList());
    }

    public static List<String> toHumanReadableArgs(List<Object> args) {
        return args.stream().map(t -> t != null ? ResolvableType.forType(t.getClass()).toString() : "null").collect(Collectors.toList());
    }

    public static List<String> toHumanReadableArgs(Executable executable) {
        Function<Integer, ResolvableType> typeResolver = executable instanceof Method ? i -> ResolvableType.forMethodParameter((Method)((Method)executable), (int)i) : i -> ResolvableType.forConstructorParameter((Constructor)((Constructor)executable), (int)i);
        Parameter[] args = executable.getParameters();
        ArrayList<String> typeNames = new ArrayList<String>(args.length);
        for (int i2 = 0; i2 < args.length; ++i2) {
            typeNames.add(typeResolver.apply(i2).toString() + " " + args[i2].getName());
        }
        return typeNames;
    }

    public static Optional<String> getCauseMessage(Throwable cause) {
        if (cause != null) {
            if (cause.getMessage() != null && !cause.getMessage().trim().isEmpty()) {
                return Optional.of(cause.getClass().getName() + " - " + cause.getMessage());
            }
            return JavaModuleUtils.getCauseMessage(cause.getCause());
        }
        return Optional.empty();
    }

    public static String getArgumentsMessage(List<String> args) {
        if (args.isEmpty()) {
            return "without any argument";
        }
        return "with arguments " + args;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, boolean expectStatic) {
        return Arrays.stream(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> expectStatic == Modifier.isStatic(m.getModifiers())).filter(m -> !m.isBridge()).collect(Collectors.toList());
    }
}

