/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.operation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchConstructorModuleException;
import org.mule.extensions.java.api.exception.NonInstantiableTypeModuleException;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.error.JavaNewInstanceErrorProvider;
import org.mule.extensions.java.internal.metadata.ConstructorTypeResolver;
import org.mule.extensions.java.internal.parameters.ConstructorIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.transformer.ParametersTransformationResult;
import org.mule.extensions.java.internal.util.JavaModuleUtils;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaNewInstanceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaNewInstanceOperation.class);
    @Inject
    private JavaModuleLoadingCache cache;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExpressionManager expressionManager;

    @Alias(value="new")
    @MediaType(value="application/java")
    @Throws(value={JavaNewInstanceErrorProvider.class})
    @OutputResolver(output=ConstructorTypeResolver.class)
    @Execution(value=ExecutionType.CPU_LITE)
    public Object newInstance(@ParameterGroup(name="Constructor") @MetadataKeyId(value=ConstructorTypeResolver.class) ConstructorIdentifier identifier, @Optional @NullSafe @Content @TypeResolver(value=ConstructorTypeResolver.class) Map<String, TypedValue<Object>> args) throws ClassNotFoundModuleException, NoSuchConstructorModuleException, ArgumentMismatchModuleException, InvocationModuleException, NonInstantiableTypeModuleException {
        Class<?> targetClass = this.cache.loadClass(identifier.getClazz());
        Constructor constructor = this.cache.getConstructor(identifier, targetClass, args);
        ParametersTransformationResult transformationResult = JavaModuleUtils.getSortedAndTransformedArgs(args, constructor, this.transformationService, this.expressionManager, LOGGER);
        if (constructor.getParameters().length > args.size()) {
            throw new ArgumentMismatchModuleException(this.getBaseFailure(identifier) + ". Too few arguments were provided for the invocation", constructor, args, transformationResult);
        }
        if (constructor.getParameters().length < args.size()) {
            JavaModuleUtils.logTooManyArgsWarning(constructor, args, identifier, LOGGER);
        }
        if (transformationResult.isSuccess()) {
            return this.invokeNew(identifier, args, constructor, transformationResult);
        }
        throw new ArgumentMismatchModuleException(this.getBaseFailure(identifier) + ". The given arguments could not be transformed to match those expected by the Constructor", constructor, args, transformationResult);
    }

    private Object invokeNew(ConstructorIdentifier identifier, Map<String, TypedValue<Object>> args, Constructor constructor, ParametersTransformationResult transformationResult) {
        try {
            return constructor.newInstance(transformationResult.getTransformed().toArray());
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentMismatchModuleException(this.getBaseFailure(identifier), constructor, args, transformationResult, e);
        }
        catch (InstantiationException e) {
            throw new NonInstantiableTypeModuleException(identifier, args, (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvocationModuleException(String.format("%s '%s' in Class '%s' ", identifier.getExecutableTypeName(), identifier.getElementId(), identifier.getClazz()), constructor, args, e);
        }
    }

    private String getBaseFailure(ExecutableIdentifier identifier) {
        return String.format("Failed to instantiate Class '%s' using the Constructor '%s'", identifier.getClazz(), identifier.getElementId());
    }
}

