
package org.mule.module.hubspot.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.hubspot.HubSpotConnector;
import org.mule.module.hubspot.adapters.HubSpotConnectorProcessAdapter;
import org.mule.module.hubspot.process.ProcessAdapter;
import org.mule.module.hubspot.process.ProcessCallback;
import org.mule.module.hubspot.process.ProcessTemplate;


/**
 * GetContactsInAListMessageProcessor invokes the {@link org.mule.module.hubspot.HubSpotConnector#getContactsInAList(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)} method in {@link HubSpotConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-04-17T08:27:27-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class GetContactsInAListMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object userId;
    protected String _userIdType;
    protected Object listId;
    protected String _listIdType;
    protected Object count;
    protected String _countType;
    protected Object property;
    protected String _propertyType;
    protected Object offset;
    protected String _offsetType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets count
     * 
     * @param value Value to set
     */
    public void setCount(Object value) {
        this.count = value;
    }

    /**
     * Sets listId
     * 
     * @param value Value to set
     */
    public void setListId(Object value) {
        this.listId = value;
    }

    /**
     * Sets userId
     * 
     * @param value Value to set
     */
    public void setUserId(Object value) {
        this.userId = value;
    }

    /**
     * Sets property
     * 
     * @param value Value to set
     */
    public void setProperty(Object value) {
        this.property = value;
    }

    /**
     * Sets offset
     * 
     * @param value Value to set
     */
    public void setOffset(Object value) {
        this.offset = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(HubSpotConnectorProcessAdapter.class, true, event);
            final String _transformedUserId = ((String) evaluateAndTransform(getMuleContext(), event, GetContactsInAListMessageProcessor.class.getDeclaredField("_userIdType").getGenericType(), null, userId));
            final String _transformedListId = ((String) evaluateAndTransform(getMuleContext(), event, GetContactsInAListMessageProcessor.class.getDeclaredField("_listIdType").getGenericType(), null, listId));
            final String _transformedCount = ((String) evaluateAndTransform(getMuleContext(), event, GetContactsInAListMessageProcessor.class.getDeclaredField("_countType").getGenericType(), null, count));
            final String _transformedProperty = ((String) evaluateAndTransform(getMuleContext(), event, GetContactsInAListMessageProcessor.class.getDeclaredField("_propertyType").getGenericType(), null, property));
            final String _transformedOffset = ((String) evaluateAndTransform(getMuleContext(), event, GetContactsInAListMessageProcessor.class.getDeclaredField("_offsetType").getGenericType(), null, offset));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((HubSpotConnector) object).getContactsInAList(_transformedUserId, _transformedListId, _transformedCount, _transformedProperty, _transformedOffset);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("getContactsInAList"), event, e);
        }
    }

}
