
package org.mule.module.hubspot.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.hubspot.HubSpotConnector;
import org.mule.module.hubspot.adapters.HubSpotConnectorProcessAdapter;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatusStatuses;


/**
 * UpdateEmailSubscriptionStatusMessageProcessor invokes the {@link org.mule.module.hubspot.HubSpotConnector#updateEmailSubscriptionStatus(java.lang.String, java.lang.String, java.lang.String, java.util.List)} method in {@link HubSpotConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-08T05:22:37-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class UpdateEmailSubscriptionStatusMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object userId;
    protected String _userIdType;
    protected Object hubId;
    protected String _hubIdType;
    protected Object email;
    protected String _emailType;
    protected Object statuses;
    protected List<EmailSubscriptionStatusStatuses> _statusesType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets hubId
     * 
     * @param value Value to set
     */
    public void setHubId(Object value) {
        this.hubId = value;
    }

    /**
     * Sets email
     * 
     * @param value Value to set
     */
    public void setEmail(Object value) {
        this.email = value;
    }

    /**
     * Sets userId
     * 
     * @param value Value to set
     */
    public void setUserId(Object value) {
        this.userId = value;
    }

    /**
     * Sets statuses
     * 
     * @param value Value to set
     */
    public void setStatuses(Object value) {
        this.statuses = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(HubSpotConnectorProcessAdapter.class, true, event);
            final String _transformedUserId = ((String) evaluateAndTransform(getMuleContext(), event, UpdateEmailSubscriptionStatusMessageProcessor.class.getDeclaredField("_userIdType").getGenericType(), null, userId));
            final String _transformedHubId = ((String) evaluateAndTransform(getMuleContext(), event, UpdateEmailSubscriptionStatusMessageProcessor.class.getDeclaredField("_hubIdType").getGenericType(), null, hubId));
            final String _transformedEmail = ((String) evaluateAndTransform(getMuleContext(), event, UpdateEmailSubscriptionStatusMessageProcessor.class.getDeclaredField("_emailType").getGenericType(), null, email));
            final List<EmailSubscriptionStatusStatuses> _transformedStatuses = ((List<EmailSubscriptionStatusStatuses> ) evaluateAndTransform(getMuleContext(), event, UpdateEmailSubscriptionStatusMessageProcessor.class.getDeclaredField("_statusesType").getGenericType(), null, statuses));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((HubSpotConnector) object).updateEmailSubscriptionStatus(_transformedUserId, _transformedHubId, _transformedEmail, _transformedStatuses);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("updateEmailSubscriptionStatus"), event, e);
        }
    }

}
