/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.store.ObjectStore;
import org.mule.module.hubspot.client.HubSpotClient;
import org.mule.module.hubspot.client.HubSpotClientUtils;
import org.mule.module.hubspot.client.HubSpotClientsManager;
import org.mule.module.hubspot.client.impl.HubSpotClientImpl;
import org.mule.module.hubspot.credential.HubSpotCredentialsManager;
import org.mule.module.hubspot.exception.HubSpotConnectorAccessTokenExpiredException;
import org.mule.module.hubspot.exception.HubSpotConnectorException;
import org.mule.module.hubspot.exception.HubSpotConnectorNoAccessTokenException;
import org.mule.module.hubspot.model.OAuthCredentials;
import org.mule.module.hubspot.model.contact.Contact;
import org.mule.module.hubspot.model.contact.ContactDeleted;
import org.mule.module.hubspot.model.contact.ContactList;
import org.mule.module.hubspot.model.contact.ContactProperties;
import org.mule.module.hubspot.model.contact.ContactQuery;
import org.mule.module.hubspot.model.contact.ContactStatistics;
import org.mule.module.hubspot.model.contactproperty.CustomContactProperty;
import org.mule.module.hubspot.model.contactproperty.CustomContactPropertyGroup;
import org.mule.module.hubspot.model.email.EmailSubscription;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatus;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatusResult;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatusStatuses;
import org.mule.module.hubspot.model.list.HubSpotList;
import org.mule.module.hubspot.model.list.HubSpotListAddContactToListResponse;
import org.mule.module.hubspot.model.list.HubSpotListFilters;
import org.mule.module.hubspot.model.list.HubSpotListLists;
import org.mule.module.hubspot.model.list.HubSpotNewList;
import org.springframework.core.annotation.Order;

@Connector(name="hubspot", schemaVersion="2.6.9", friendlyName="HubSpot", minMuleVersion="3.3.0")
public class HubSpotConnector {
    public static final String HUB_SPOT_URL_API = "http://hubapi.com";
    public static final String HUB_SPOT_URL_AUTH = "https://app.hubspot.com/auth/authenticate";
    public static final String API_VERSION = "v1";
    private static final Pattern OFFLINE_SCOPE_PATTER = Pattern.compile("offline");
    private static final Log logger = LogFactory.getLog(HubSpotConnector.class);
    @Configurable
    @Optional
    @Order(value=1)
    private String clientId;
    @Configurable
    @Optional
    @Order(value=2)
    private String hubId;
    @Configurable
    @Optional
    @Order(value=3)
    private String scope;
    @Configurable
    @Optional
    @Order(value=4)
    private String callbackUrl;
    @Configurable
    @Optional
    @Order(value=5)
    @Default(value="_defaultUserObjectStore")
    private ObjectStore objectStore;
    private HubSpotCredentialsManager credentialsManager;
    private HubSpotClientsManager clientsManager;

    public HubSpotCredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    public void setCredentialsManager(HubSpotCredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }

    public HubSpotClientsManager getClientsManager() {
        return this.clientsManager;
    }

    public void setClientsManager(HubSpotClientsManager clientsManager) {
        this.clientsManager = clientsManager;
    }

    @PostConstruct
    public void initialize() {
        this.credentialsManager = new HubSpotCredentialsManager(this.objectStore);
        this.clientsManager = new HubSpotClientsManager();
    }

    @Processor
    public String authenticate(String userId, @Optional String callbackUrl, @Optional String clientId, @Optional String hubId, @Optional String scope, @OutboundHeaders Map<String, Object> headers) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException {
        HubSpotClientImpl client = new HubSpotClientImpl(HUB_SPOT_URL_API, HUB_SPOT_URL_AUTH, API_VERSION, clientId != null ? clientId : this.clientId, hubId != null ? hubId : this.hubId, scope != null ? scope : this.scope, callbackUrl != null ? callbackUrl : this.callbackUrl);
        this.clientsManager.addClient(userId, client);
        Matcher offlineScopeMatcher = OFFLINE_SCOPE_PATTER.matcher(scope != null ? scope : this.scope);
        Boolean offlineScope = offlineScopeMatcher.find();
        OAuthCredentials credentials = this.credentialsManager.hasUserAccessToken(userId) ? this.credentialsManager.getCredentials(userId) : new OAuthCredentials();
        credentials.setUserId(userId);
        credentials.setClientId(clientId != null ? clientId : this.clientId);
        credentials.setHubId(hubId != null ? hubId : this.hubId);
        credentials.setOfflineScope(offlineScope);
        this.credentialsManager.setCredentias(credentials);
        if (!offlineScope.booleanValue()) {
            logger.warn((Object)String.format("The userId %s does not have an offline scope. This will prevent from refreshing the access token automatically when this one expires", userId));
        }
        return client.authenticate(userId, headers);
    }

    @Processor
    public String authenticateResponse(String inputRequest) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException {
        OAuthCredentials credentials = HubSpotClientUtils.authenticateResponse(inputRequest);
        try {
            credentials.setClientId(this.credentialsManager.getCredentialsClientId(credentials.getUserId()));
            credentials.setHubId(this.credentialsManager.getCredentialsHubId(credentials.getUserId()));
            credentials.setOfflineScope(this.credentialsManager.getCredentialsOfflineScope(credentials.getUserId()));
        }
        catch (HubSpotConnectorNoAccessTokenException e) {
            throw new HubSpotConnectorException(String.format("Authenticate operation must be called first for user %s before authenticateResponse", credentials.getUserId()));
        }
        this.credentialsManager.setCredentias(credentials);
        return credentials.getUserId();
    }

    @Processor
    public boolean hasUserAccessToken(String userId) {
        return this.credentialsManager.hasUserAccessToken(userId);
    }

    @Processor
    public ContactList getAllContacts(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String contactOffset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getAllContacts(cred.getAccessToken(), userId, count, contactOffset);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getAllContacts(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, count, contactOffset);
        }
    }

    @Processor
    public ContactList getRecentContacts(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String timeOffset, @Optional @Default(value="") String contactOffset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getRecentContacts(cred.getAccessToken(), userId, count, timeOffset, contactOffset);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getRecentContacts(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, count, timeOffset, contactOffset);
        }
    }

    @Processor
    public Contact getContactById(String userId, String contactId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactById(cred.getAccessToken(), userId, contactId);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactById(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactId);
        }
    }

    @Processor
    public Contact getContactByEmail(String userId, String contactEmail) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactByEmail(cred.getAccessToken(), userId, contactEmail);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactByEmail(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactEmail);
        }
    }

    @Processor
    public Contact getContactByUserToken(String userId, String contactUserToken) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactByUserToken(cred.getAccessToken(), userId, contactUserToken);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactByUserToken(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactUserToken);
        }
    }

    @Processor
    public ContactQuery getContactsByQuery(String userId, String query, @Optional @Default(value="") String count) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactsByQuery(cred.getAccessToken(), userId, query, count);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactsByQuery(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, query, count);
        }
    }

    @Processor
    public ContactDeleted deleteContact(String userId, String contactId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.deleteContact(cred.getAccessToken(), userId, contactId);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.deleteContact(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactId);
        }
    }

    @Processor
    public ContactProperties updateContact(String userId, String contactId, ContactProperties contactProperties) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            client.updateContact(cred.getAccessToken(), userId, contactId, contactProperties);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            client.updateContact(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactId, contactProperties);
        }
        return contactProperties;
    }

    @Processor
    public Contact createContact(String userId, ContactProperties contactProperties) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.createContact(cred.getAccessToken(), userId, contactProperties);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.createContact(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactProperties);
        }
    }

    @Processor
    public ContactStatistics getContactStatistics(String userId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactStatistics(cred.getAccessToken(), userId);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactStatistics(this.credentialsManager.getCredentials(userId).getAccessToken(), userId);
        }
    }

    @Processor
    public HubSpotListLists getContactsLists(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String offset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactsLists(cred.getAccessToken(), userId, count, offset);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactsLists(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, count, offset);
        }
    }

    @Processor
    public HubSpotList getContactListById(String userId, String listId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactListById(cred.getAccessToken(), userId, listId);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactListById(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, listId);
        }
    }

    @Processor
    public HubSpotListLists getDynamicContactLists(String userId, @Optional @Default(value="") String count, @Optional @Default(value="") String offset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getDynamicContactLists(cred.getAccessToken(), userId, count, offset);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getDynamicContactLists(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, count, offset);
        }
    }

    @Processor
    public ContactList getContactsInAList(String userId, String listId, @Optional @Default(value="") String count, @Optional @Default(value="") String property, @Optional @Default(value="") String offset) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getContactsInAList(cred.getAccessToken(), userId, listId, count, property, offset);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getContactsInAList(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, listId, count, property, offset);
        }
    }

    @Processor
    public EmailSubscription getEmailSubscriptions(String userId, @Optional String hubId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getEmailSubscriptions(cred.getAccessToken(), userId, hubId != null ? hubId : cred.getHubId());
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getEmailSubscriptions(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, hubId != null ? hubId : cred.getHubId());
        }
    }

    @Processor
    public EmailSubscriptionStatus getEmailSubscriptionStatus(String userId, @Optional String hubId, String email) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getEmailSubscriptionStatus(cred.getAccessToken(), userId, hubId != null ? hubId : cred.getHubId(), email);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getEmailSubscriptionStatus(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, hubId != null ? hubId : cred.getHubId(), email);
        }
    }

    @Processor
    public EmailSubscriptionStatusResult updateEmailSubscriptionStatus(String userId, @Optional String hubId, String email, List<EmailSubscriptionStatusStatuses> statuses) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.updateEmailSubscriptionStatus(cred.getAccessToken(), userId, hubId != null ? hubId : cred.getHubId(), email, statuses);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.updateEmailSubscriptionStatus(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, hubId != null ? hubId : cred.getHubId(), email, statuses);
        }
    }

    @Processor
    public EmailSubscriptionStatusResult updateEmailSubscriptionStatusUnsubscribeFromAll(String userId, @Optional String hubId, String email) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.updateEmailSubscriptionStatusUnsubscribeFromAll(cred.getAccessToken(), userId, hubId != null ? hubId : cred.getHubId(), email);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.updateEmailSubscriptionStatusUnsubscribeFromAll(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, hubId != null ? hubId : cred.getHubId(), email);
        }
    }

    @Processor
    public List<CustomContactProperty> getAllCustomProperties(String userId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getAllCustomProperties(cred.getAccessToken(), userId);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getAllCustomProperties(this.credentialsManager.getCredentials(userId).getAccessToken(), userId);
        }
    }

    @Processor
    public CustomContactProperty createCustomProperty(String userId, CustomContactProperty contactProperty) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.createCustomProperty(cred.getAccessToken(), userId, contactProperty);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.createCustomProperty(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactProperty);
        }
    }

    @Processor
    public CustomContactProperty updateCustomProperty(String userId, String propertyName, CustomContactProperty contactProperty) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.updateCustomProperty(cred.getAccessToken(), userId, propertyName, contactProperty);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.updateCustomProperty(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, propertyName, contactProperty);
        }
    }

    @Processor
    public void deleteCustomProperty(String userId, String contactPropertyName) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            client.deleteCustomProperty(cred.getAccessToken(), userId, contactPropertyName);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            client.deleteCustomProperty(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, contactPropertyName);
        }
    }

    @Processor
    public CustomContactPropertyGroup getCustomPropertyGroup(String userId, String groupName) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.getCustomPropertyGroup(cred.getAccessToken(), userId, groupName);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.getCustomPropertyGroup(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, groupName);
        }
    }

    @Processor
    public CustomContactPropertyGroup createCustomPropertyGroup(String userId, CustomContactPropertyGroup customContactPropertyGroup) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.createCustomPropertyGroup(cred.getAccessToken(), userId, customContactPropertyGroup);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.createCustomPropertyGroup(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, customContactPropertyGroup);
        }
    }

    @Processor
    public CustomContactPropertyGroup updateCustomPropertyGroup(String userId, String groupName, CustomContactPropertyGroup customContactPropertyGroup) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.updateCustomPropertyGroup(cred.getAccessToken(), userId, groupName, customContactPropertyGroup);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.updateCustomPropertyGroup(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, groupName, customContactPropertyGroup);
        }
    }

    @Processor
    public void deleteCustomPropertyGroup(String userId, String groupName) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            client.deleteCustomPropertyGroup(cred.getAccessToken(), userId, groupName);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            client.deleteCustomPropertyGroup(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, groupName);
        }
    }

    @Processor
    public HubSpotListAddContactToListResponse addExistingContactInAList(String userId, String listId, String contactId) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.addExistingContactInAList(cred.getAccessToken(), userId, listId, contactId);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.addExistingContactInAList(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, listId, contactId);
        }
    }

    @Processor
    public HubSpotList createContactList(String userId, HubSpotNewList list, @Optional List<HubSpotListFilters> filters) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException {
        OAuthCredentials cred = this.credentialsManager.getCredentials(userId);
        HubSpotClient client = this.clientsManager.getOrCreateClient(userId, cred);
        try {
            return client.createContactList(cred.getAccessToken(), userId, list, filters);
        }
        catch (HubSpotConnectorAccessTokenExpiredException e) {
            client.refreshToken(this.credentialsManager, userId);
            return client.createContactList(this.credentialsManager.getCredentials(userId).getAccessToken(), userId, list, filters);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getHubId() {
        return this.hubId;
    }

    public void setHubId(String hubId) {
        this.hubId = hubId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }
}

