/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.client;

import java.util.List;
import java.util.Map;
import org.mule.module.hubspot.credential.HubSpotCredentialsManager;
import org.mule.module.hubspot.exception.HubSpotConnectorAccessTokenExpiredException;
import org.mule.module.hubspot.exception.HubSpotConnectorException;
import org.mule.module.hubspot.exception.HubSpotConnectorNoAccessTokenException;
import org.mule.module.hubspot.model.contact.Contact;
import org.mule.module.hubspot.model.contact.ContactDeleted;
import org.mule.module.hubspot.model.contact.ContactList;
import org.mule.module.hubspot.model.contact.ContactProperties;
import org.mule.module.hubspot.model.contact.ContactQuery;
import org.mule.module.hubspot.model.contact.ContactStatistics;
import org.mule.module.hubspot.model.contactproperty.CustomContactProperty;
import org.mule.module.hubspot.model.contactproperty.CustomContactPropertyGroup;
import org.mule.module.hubspot.model.email.EmailSubscription;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatus;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatusResult;
import org.mule.module.hubspot.model.email.EmailSubscriptionStatusStatuses;
import org.mule.module.hubspot.model.list.HubSpotList;
import org.mule.module.hubspot.model.list.HubSpotListAddContactToListResponse;
import org.mule.module.hubspot.model.list.HubSpotListFilters;
import org.mule.module.hubspot.model.list.HubSpotListLists;
import org.mule.module.hubspot.model.list.HubSpotNewList;

public interface HubSpotClient {
    public String authenticate(String var1, Map<String, Object> var2) throws HubSpotConnectorException;

    public ContactList getAllContacts(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public ContactList getRecentContacts(String var1, String var2, String var3, String var4, String var5) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public Contact getContactById(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public Contact getContactByEmail(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public Contact getContactByUserToken(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public ContactQuery getContactsByQuery(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public ContactDeleted deleteContact(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public void updateContact(String var1, String var2, String var3, ContactProperties var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public Contact createContact(String var1, String var2, ContactProperties var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public ContactStatistics getContactStatistics(String var1, String var2) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public HubSpotListLists getContactsLists(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public HubSpotList getContactListById(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public HubSpotListLists getDynamicContactLists(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public ContactList getContactsInAList(String var1, String var2, String var3, String var4, String var5, String var6) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public HubSpotListAddContactToListResponse addExistingContactInAList(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public HubSpotList createContactList(String var1, String var2, HubSpotNewList var3, List<HubSpotListFilters> var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public EmailSubscription getEmailSubscriptions(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public EmailSubscriptionStatus getEmailSubscriptionStatus(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public EmailSubscriptionStatusResult updateEmailSubscriptionStatus(String var1, String var2, String var3, String var4, List<EmailSubscriptionStatusStatuses> var5) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public EmailSubscriptionStatusResult updateEmailSubscriptionStatusUnsubscribeFromAll(String var1, String var2, String var3, String var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public List<CustomContactProperty> getAllCustomProperties(String var1, String var2) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public CustomContactProperty createCustomProperty(String var1, String var2, CustomContactProperty var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public CustomContactProperty updateCustomProperty(String var1, String var2, String var3, CustomContactProperty var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public void deleteCustomProperty(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public CustomContactPropertyGroup getCustomPropertyGroup(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public CustomContactPropertyGroup createCustomPropertyGroup(String var1, String var2, CustomContactPropertyGroup var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public CustomContactPropertyGroup updateCustomPropertyGroup(String var1, String var2, String var3, CustomContactPropertyGroup var4) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public void deleteCustomPropertyGroup(String var1, String var2, String var3) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;

    public void refreshToken(HubSpotCredentialsManager var1, String var2) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException, HubSpotConnectorAccessTokenExpiredException;
}

