/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.serialization;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.mule.module.hubspot.model.contact.ContactProperties;
import org.mule.module.hubspot.model.contact.ContactPropertiesLifecycleStage;
import org.mule.module.hubspot.model.contact.ContactPropertiesNumberOfEmployees;

public class ContactJacksonSerializer
extends JsonSerializer<ContactProperties> {
    public void serialize(ContactProperties value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        PropertyDescriptor[] propertyDescriptor;
        if (value == null) {
            return;
        }
        try {
            propertyDescriptor = Introspector.getBeanInfo(ContactProperties.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IOException(e);
        }
        jgen.writeStartArray();
        for (PropertyDescriptor pd : propertyDescriptor) {
            Object propVal;
            if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
            if ("customProperties".equals(pd.getName())) {
                if (value.getCustomProperties() == null) continue;
                for (String key : value.getCustomProperties().keySet()) {
                    jgen.writeStartObject();
                    jgen.writeStringField("property", key);
                    jgen.writeStringField("value", value.getCustomProperties().get(key));
                    jgen.writeEndObject();
                }
                continue;
            }
            try {
                propVal = pd.getReadMethod().invoke((Object)value, new Object[0]);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (propVal == null) continue;
            jgen.writeStartObject();
            jgen.writeStringField("property", pd.getName());
            if (propVal instanceof Long) {
                jgen.writeNumberField("value", ((Long)propVal).longValue());
            } else if (propVal instanceof String) {
                jgen.writeStringField("value", (String)propVal);
            } else if (propVal instanceof ContactPropertiesLifecycleStage) {
                jgen.writeStringField("value", ((ContactPropertiesLifecycleStage)((Object)propVal)).getValue());
            } else if (propVal instanceof ContactPropertiesNumberOfEmployees) {
                jgen.writeStringField("value", ((ContactPropertiesNumberOfEmployees)((Object)propVal)).getValue());
            }
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
    }
}

