/**
 * Copyright (c) MuleSoft, Inc. All rights reserved. http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.md file.
 */
package org.mule.module.hubspot.model.contact;

import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonSerialize(include = Inclusion.NON_NULL)
public class ContactList {

    private List<Contact> contacts;
    private Boolean hasMore;
    private Long vidOffset;
    private Long timeOffset;

    public ContactList() {
    }

    @JsonProperty("has-more")
    public Boolean getHasMore() {
        return hasMore;
    }

    @JsonProperty("has-more")
    public void setHasMore(final Boolean hasMore) {
        this.hasMore = hasMore;
    }

    @JsonProperty("vid-offset")
    public Long getVidOffset() {
        return vidOffset;
    }

    @JsonProperty("vid-offset")
    public void setVidOffset(final Long vidOffset) {
        this.vidOffset = vidOffset;
    }

    @JsonProperty
    public List<Contact> getContacts() {
        return contacts;
    }

    @JsonProperty
    public void setContacts(final List<Contact> contacts) {
        this.contacts = contacts;
    }

    @JsonProperty("time-offset")
    public Long getTimeOffset() {
        return timeOffset;
    }

    @JsonProperty("time-offset")
    public void setTimeOffset(final Long timeOffset) {
        this.timeOffset = timeOffset;
    }
}