/**
 * Copyright (c) MuleSoft, Inc. All rights reserved. http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.md file.
 */
package org.mule.module.hubspot.model.contactproperty;

import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonSerialize(include = Inclusion.NON_NULL)
public class CustomContactPropertyGroup {

    private String name;
    private String displayName;
    private Integer displayOrder;
    private Long portalId;
    private List<CustomContactProperty> properties;

    @JsonProperty
    public String getName() {
        return name;
    }

    @JsonProperty
    public void setName(final String name) {
        this.name = name;
    }

    @JsonProperty
    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty
    public void setDisplayName(final String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty
    public Integer getDisplayOrder() {
        return displayOrder;
    }

    @JsonProperty
    public void setDisplayOrder(final Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    @JsonProperty
    public Long getPortalId() {
        return portalId;
    }

    @JsonProperty
    public void setPortalId(final Long portalId) {
        this.portalId = portalId;
    }

    @JsonProperty
    public List<CustomContactProperty> getProperties() {
        return properties;
    }

    @JsonProperty
    public void setProperties(final List<CustomContactProperty> properties) {
        this.properties = properties;
    }
}
