/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.module.hubspot.exception.HubSpotConnectorAccessTokenExpiredException;
import org.mule.module.hubspot.exception.HubSpotConnectorException;
import org.mule.module.hubspot.exception.HubSpotConnectorNoAccessTokenException;
import org.mule.module.hubspot.model.HubSpotWebResourceMethods;
import org.mule.module.hubspot.model.OAuthCredentials;

public class HubSpotClientUtils {
    private static final Log logger = LogFactory.getLog(HubSpotClientUtils.class);
    private static final ObjectMapper jacksonMapper = new ObjectMapper();
    private static final Pattern PATTERN_ACCESS_TOKEN = Pattern.compile("access_token=([^&]+)&?");
    private static final Pattern PATTERN_EXPIRES_AT = Pattern.compile("expires_in=([^&]+)&?");
    private static final Pattern PATTERN_REFRESH_TOKEN = Pattern.compile("refresh_token=([^&]+)&?");
    private static final Pattern PATTERN_USERID = Pattern.compile("userid=([^&]+)&?");
    private static final Pattern PATTERN_ERROR = Pattern.compile("error=([^&]+)&?");

    public static String transformObjectToJson(Object o) throws HubSpotConnectorException {
        try {
            return jacksonMapper.writeValueAsString(o);
        }
        catch (JsonGenerationException e) {
            throw new HubSpotConnectorException("Cannot generate the Json from object", e);
        }
        catch (JsonMappingException e) {
            throw new HubSpotConnectorException("Cannot map the Json from object", e);
        }
        catch (IOException e) {
            throw new HubSpotConnectorException(e);
        }
    }

    public static String webResourceGet(WebResource wr, String userId, HubSpotWebResourceMethods method) throws HubSpotConnectorAccessTokenExpiredException, HubSpotConnectorException {
        return HubSpotClientUtils.webResourceGet(String.class, wr, userId, method);
    }

    public static String webResourceGet(WebResource wr, String userId, HubSpotWebResourceMethods method, String requestBody) throws HubSpotConnectorAccessTokenExpiredException, HubSpotConnectorException {
        return HubSpotClientUtils.webResourceGet(String.class, wr, userId, method, requestBody);
    }

    public static <T> T webResourceGet(Class<T> type, WebResource wr, String userId, HubSpotWebResourceMethods method) throws HubSpotConnectorAccessTokenExpiredException, HubSpotConnectorException {
        return HubSpotClientUtils.webResourceGet(type, wr, userId, method, null);
    }

    public static <T> T webResourceGet(Class<T> type, WebResource wr, String userId, HubSpotWebResourceMethods method, String requestBody) throws HubSpotConnectorAccessTokenExpiredException, HubSpotConnectorException {
        try {
            String res = HubSpotClientUtils.webResourceCallByEnumType(wr, method, requestBody);
            if (type.equals(String.class)) {
                return (T)res;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(res.getBytes());
            return (T)jacksonMapper.readValue((InputStream)is, type);
        }
        catch (UniformInterfaceException e) {
            ClientResponse cl = e.getResponse();
            int statusCode = cl.getStatus();
            String message = "";
            try {
                message = (String)cl.getEntity(String.class);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (statusCode == 204) {
                return null;
            }
            if (statusCode == 401) {
                throw new HubSpotConnectorAccessTokenExpiredException("The access token for the userId " + userId + "has expired", e);
            }
            throw new HubSpotConnectorException(String.format("ERROR - statusCode: %d - message: %s", statusCode, message), e);
        }
        catch (JsonParseException e) {
            throw new HubSpotConnectorException("ERROR - Error Parsing the JSON", e);
        }
        catch (JsonMappingException e) {
            throw new HubSpotConnectorException("ERROR - Error Mapping the JSON", e);
        }
        catch (IOException e) {
            throw new HubSpotConnectorException(e);
        }
    }

    private static String webResourceCallByEnumType(WebResource wr, HubSpotWebResourceMethods method, String requestBody) {
        if (HubSpotWebResourceMethods.GET.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).get(String.class);
        }
        if (HubSpotWebResourceMethods.POST.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).post(String.class, (Object)requestBody);
        }
        if (HubSpotWebResourceMethods.PUT.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).put(String.class, (Object)requestBody);
        }
        if (HubSpotWebResourceMethods.DELETE.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_JSON_TYPE).delete(String.class);
        }
        if (HubSpotWebResourceMethods.REFRESH.equals((Object)method)) {
            return (String)wr.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(String.class, (Object)requestBody);
        }
        return null;
    }

    public static OAuthCredentials authenticateResponse(String inputRequest) throws HubSpotConnectorException, HubSpotConnectorNoAccessTokenException {
        if (StringUtils.isEmpty((String)inputRequest)) {
            throw new HubSpotConnectorException("The parameter inputRequest can not be empty");
        }
        OAuthCredentials oACreds = new OAuthCredentials();
        Matcher m = PATTERN_ERROR.matcher(inputRequest);
        if (m.find()) {
            String errDesc = m.group(1);
            if (errDesc.equals("invalid_scope")) {
                throw new HubSpotConnectorException("The configuration is requesting a scope that the service application does not have available.");
            }
            throw new HubSpotConnectorException("The service has responded with an error message: " + errDesc);
        }
        m = PATTERN_USERID.matcher(inputRequest);
        if (m.find()) {
            oACreds.setUserId(m.group(1));
        }
        if ((m = PATTERN_ACCESS_TOKEN.matcher(inputRequest)).find()) {
            oACreds.setAccessToken(m.group(1));
        }
        if ((m = PATTERN_EXPIRES_AT.matcher(inputRequest)).find()) {
            oACreds.setExpiresAt(m.group(1));
        }
        if ((m = PATTERN_REFRESH_TOKEN.matcher(inputRequest)).find()) {
            oACreds.setRefreshToken(m.group(1));
        }
        if (oACreds.getAccessToken() == null) {
            logger.error((Object)("Cannot find the access_token in the response:" + inputRequest));
            throw new HubSpotConnectorNoAccessTokenException("The response of the authentication process does not have an access token. Url:" + inputRequest);
        }
        logger.debug((Object)("Recived credentials for user:" + oACreds.getUserId()));
        return oACreds;
    }
}

