/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.config;

import org.mule.config.MuleManifest;
import org.mule.module.hubspot.adapters.HubSpotConnectorProcessAdapter;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class HubSpotConnectorConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(HubSpotConnectorConfigDefinitionParser.class);

    public String moduleName() {
        return "HubSpot";
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        this.parseProperty(builder, element, "clientId", "clientId");
        this.parseProperty(builder, element, "hubId", "hubId");
        this.parseProperty(builder, element, "scope", "scope");
        this.parseProperty(builder, element, "callbackUrl", "callbackUrl");
        if (this.hasAttribute(element, "objectStore-ref")) {
            if (element.getAttribute("objectStore-ref").startsWith("#")) {
                builder.addPropertyValue("objectStore", (Object)element.getAttribute("objectStore-ref"));
            } else {
                builder.addPropertyValue("objectStore", (Object)new RuntimeBeanReference(element.getAttribute("objectStore-ref")));
            }
        }
        this.setInitMethodIfNeeded(builder, HubSpotConnectorProcessAdapter.class);
        this.setDestroyMethodIfNeeded(builder, HubSpotConnectorProcessAdapter.class);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)HubSpotConnectorProcessAdapter.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [config] within the connector [hubspot] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [config] within the connector [hubspot] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

