/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.credential;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.module.hubspot.exception.HubSpotConnectorException;
import org.mule.module.hubspot.exception.HubSpotConnectorNoAccessTokenException;
import org.mule.module.hubspot.model.OAuthCredentials;

public class HubSpotCredentialsManager {
    private final ObjectStore credentialsMap;

    public HubSpotCredentialsManager(ObjectStore objStore) {
        this.credentialsMap = objStore;
    }

    public OAuthCredentials getCredentials(String userId) throws HubSpotConnectorNoAccessTokenException {
        OAuthCredentials oACreds;
        try {
            oACreds = (OAuthCredentials)this.credentialsMap.retrieve((Serializable)((Object)userId));
        }
        catch (ObjectStoreException e) {
            throw new HubSpotConnectorNoAccessTokenException("The user with id " + userId + " does not have credentials");
        }
        return oACreds;
    }

    public String getCredentialsAccessToken(String userId) throws HubSpotConnectorNoAccessTokenException {
        return this.getCredentials(userId).getAccessToken();
    }

    public void setCredentias(OAuthCredentials credentials) throws HubSpotConnectorException {
        try {
            this.credentialsMap.store((Serializable)((Object)credentials.getUserId()), (Serializable)credentials);
        }
        catch (ObjectAlreadyExistsException ex) {
            try {
                this.credentialsMap.remove((Serializable)((Object)credentials.getUserId()));
                this.credentialsMap.store((Serializable)((Object)credentials.getUserId()), (Serializable)credentials);
            }
            catch (ObjectStoreException e) {
                throw new HubSpotConnectorException("Error trying to overwrite credential", ex);
            }
        }
        catch (ObjectStoreException e) {
            throw new HubSpotConnectorException("Error trying to store credential", e);
        }
    }

    public String getCredentialsClientId(String userId) throws HubSpotConnectorNoAccessTokenException {
        return this.getCredentials(userId).getClientId();
    }

    public String getCredentialsHubId(String userId) throws HubSpotConnectorNoAccessTokenException {
        return this.getCredentials(userId).getHubId();
    }

    public Boolean getCredentialsOfflineScope(String userId) throws HubSpotConnectorNoAccessTokenException {
        return this.getCredentials(userId).getOfflineScope();
    }

    public boolean hasUserAccessToken(String userId) {
        try {
            return this.credentialsMap.contains((Serializable)((Object)userId)) && StringUtils.isNotEmpty((String)((OAuthCredentials)this.credentialsMap.retrieve((Serializable)((Object)userId))).getAccessToken());
        }
        catch (ObjectStoreException e) {
            return false;
        }
    }
}

