/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.iterable;

import java.util.Iterator;
import org.mule.module.hubspot.HubSpotConnector;
import org.mule.module.hubspot.model.contact.Contact;
import org.mule.module.hubspot.model.contact.ContactList;
import org.mule.modules.utils.pagination.PaginatedCollection;

public class GetRecentContactsCollection
extends PaginatedCollection<Contact, ContactList> {
    private ContactList firstPage;
    private final HubSpotConnector connector;
    private final ContactList contactList;
    private final String userId;
    private final String count;

    public GetRecentContactsCollection(HubSpotConnector connector, ContactList contactList, String userId, String count) {
        this.connector = connector;
        this.contactList = contactList;
        this.userId = userId;
        this.count = count;
    }

    public boolean isEmpty() {
        return this.size() != 0;
    }

    public int size() {
        return -1;
    }

    protected ContactList firstPage() {
        if (this.firstPage == null) {
            this.firstPage = this.contactList;
        }
        return this.firstPage;
    }

    protected boolean hasNextPage(ContactList contactList) {
        return contactList.getHasMore();
    }

    protected ContactList nextPage(ContactList contactList) {
        try {
            return this.connector.getRecentContacts(this.userId, this.count, contactList.getTimeOffset().toString(), contactList.getVidOffset().toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected Iterator<Contact> pageIterator(ContactList contactList) {
        return contactList.getContacts().iterator();
    }

    public Object[] toArray() {
        return null;
    }

    public <Type> Type[] toArray(Type[] a) {
        return null;
    }
}

