/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.hubspot.processors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.PropertyScope;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.3.7.2.internal.metadata.fixes.STUDIO7157;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.hubspot.HubSpotConnector;
import org.mule.security.oauth.callback.ProcessCallback;

public class AuthenticateMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object userId;
    protected String _userIdType;
    protected Object callbackUrl;
    protected String _callbackUrlType;
    protected Object clientId;
    protected String _clientIdType;
    protected Object hubId;
    protected String _hubIdType;
    protected Object scope;
    protected String _scopeType;
    protected Object headers;
    protected Map<String, Object> _headersType;

    public AuthenticateMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setHeaders(Object value) {
        this.headers = value;
    }

    public void setHubId(Object value) {
        this.hubId = value;
    }

    public void setCallbackUrl(Object value) {
        this.callbackUrl = value;
    }

    public void setScope(Object value) {
        this.scope = value;
    }

    public void setUserId(Object value) {
        this.userId = value;
    }

    public void setClientId(Object value) {
        this.clientId = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedUserId = (String)this.evaluateAndTransform(this.getMuleContext(), event, AuthenticateMessageProcessor.class.getDeclaredField("_userIdType").getGenericType(), null, this.userId);
        final String _transformedCallbackUrl = (String)this.evaluateAndTransform(this.getMuleContext(), event, AuthenticateMessageProcessor.class.getDeclaredField("_callbackUrlType").getGenericType(), null, this.callbackUrl);
        final String _transformedClientId = (String)this.evaluateAndTransform(this.getMuleContext(), event, AuthenticateMessageProcessor.class.getDeclaredField("_clientIdType").getGenericType(), null, this.clientId);
        final String _transformedHubId = (String)this.evaluateAndTransform(this.getMuleContext(), event, AuthenticateMessageProcessor.class.getDeclaredField("_hubIdType").getGenericType(), null, this.hubId);
        final String _transformedScope = (String)this.evaluateAndTransform(this.getMuleContext(), event, AuthenticateMessageProcessor.class.getDeclaredField("_scopeType").getGenericType(), null, this.scope);
        final HashMap _transformedHeaders = new HashMap();
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return null;
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                return ((HubSpotConnector)object).authenticate(_transformedUserId, _transformedCallbackUrl, _transformedClientId, _transformedHubId, _transformedScope, _transformedHeaders);
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        if (_transformedHeaders != null && !_transformedHeaders.isEmpty()) {
            event.getMessage().addProperties(_transformedHeaders, PropertyScope.OUTBOUND);
        }
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        MetaDataModel metaDataPayload = this.getPojoOrSimpleModel(String.class);
        DefaultMetaDataKey keyForStudio = new DefaultMetaDataKey("OUTPUT_METADATA", null);
        metaDataPayload.addProperty((MetaDataModelProperty)STUDIO7157.getStructureIdentifierMetaDataModelProperty((MetaDataKey)keyForStudio, false, false));
        return new DefaultResult((Object)new DefaultMetaData(metaDataPayload));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at HubSpotConnector at authenticate retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

