
package org.mule.module.kindling.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.kindling.KindlingConnector;
import org.mule.module.kindling.connectivity.KindlingConnectorConnectionManager;
import org.mule.module.kindling.types.KindlingIdeaFilter;


/**
 * RetrieveIdeasMessageProcessor invokes the {@link org.mule.module.kindling.KindlingConnector#retrieveIdeas(java.lang.Integer, java.lang.String, java.lang.Integer, java.lang.Integer, java.lang.String, java.lang.Boolean, java.lang.String, java.lang.String, java.lang.String, org.mule.module.kindling.types.KindlingIdeaFilter)} method in {@link KindlingConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-08T03:29:54-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class RetrieveIdeasMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object depth;
    protected Integer _depthType;
    protected Object sort;
    protected String _sortType;
    protected Object page;
    protected Integer _pageType;
    protected Object limit;
    protected Integer _limitType;
    protected Object state;
    protected String _stateType;
    protected Object allowsVoting;
    protected Boolean _allowsVotingType;
    protected Object query;
    protected String _queryType;
    protected Object authorId;
    protected String _authorIdType;
    protected Object categoryId;
    protected String _categoryIdType;
    protected Object filter;
    protected KindlingIdeaFilter _filterType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets limit
     * 
     * @param value Value to set
     */
    public void setLimit(Object value) {
        this.limit = value;
    }

    /**
     * Sets allowsVoting
     * 
     * @param value Value to set
     */
    public void setAllowsVoting(Object value) {
        this.allowsVoting = value;
    }

    /**
     * Sets sort
     * 
     * @param value Value to set
     */
    public void setSort(Object value) {
        this.sort = value;
    }

    /**
     * Sets page
     * 
     * @param value Value to set
     */
    public void setPage(Object value) {
        this.page = value;
    }

    /**
     * Sets query
     * 
     * @param value Value to set
     */
    public void setQuery(Object value) {
        this.query = value;
    }

    /**
     * Sets categoryId
     * 
     * @param value Value to set
     */
    public void setCategoryId(Object value) {
        this.categoryId = value;
    }

    /**
     * Sets state
     * 
     * @param value Value to set
     */
    public void setState(Object value) {
        this.state = value;
    }

    /**
     * Sets filter
     * 
     * @param value Value to set
     */
    public void setFilter(Object value) {
        this.filter = value;
    }

    /**
     * Sets depth
     * 
     * @param value Value to set
     */
    public void setDepth(Object value) {
        this.depth = value;
    }

    /**
     * Sets authorId
     * 
     * @param value Value to set
     */
    public void setAuthorId(Object value) {
        this.authorId = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(KindlingConnectorConnectionManager.class, true, event);
            final Integer _transformedDepth = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_depthType").getGenericType(), null, depth));
            final String _transformedSort = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_sortType").getGenericType(), null, sort));
            final Integer _transformedPage = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_pageType").getGenericType(), null, page));
            final Integer _transformedLimit = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_limitType").getGenericType(), null, limit));
            final String _transformedState = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_stateType").getGenericType(), null, state));
            final Boolean _transformedAllowsVoting = ((Boolean) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_allowsVotingType").getGenericType(), null, allowsVoting));
            final String _transformedQuery = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_queryType").getGenericType(), null, query));
            final String _transformedAuthorId = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_authorIdType").getGenericType(), null, authorId));
            final String _transformedCategoryId = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_categoryIdType").getGenericType(), null, categoryId));
            final KindlingIdeaFilter _transformedFilter = ((KindlingIdeaFilter) evaluateAndTransform(getMuleContext(), event, RetrieveIdeasMessageProcessor.class.getDeclaredField("_filterType").getGenericType(), null, filter));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((KindlingConnector) object).retrieveIdeas(_transformedDepth, _transformedSort, _transformedPage, _transformedLimit, _transformedState, _transformedAllowsVoting, _transformedQuery, _transformedAuthorId, _transformedCategoryId, _transformedFilter);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("retrieveIdeas"), event, e);
        }
    }

}
