
package org.mule.module.kindling.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.kindling.KindlingConnector;
import org.mule.module.kindling.connectivity.KindlingConnectorConnectionManager;
import org.mule.module.kindling.types.KindlingUserDigest;
import org.mule.module.kindling.types.KindlingUserReputationTimeframe;
import org.mule.module.kindling.types.KindlingUserState;


/**
 * RetrieveUsersMessageProcessor invokes the {@link org.mule.module.kindling.KindlingConnector#retrieveUsers(java.lang.Integer, java.lang.String, java.lang.Integer, java.lang.Integer, org.mule.module.kindling.types.KindlingUserState, java.lang.Integer, org.mule.module.kindling.types.KindlingUserDigest, java.lang.String, org.mule.module.kindling.types.KindlingUserReputationTimeframe)} method in {@link KindlingConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-08T03:29:54-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class RetrieveUsersMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object depth;
    protected Integer _depthType;
    protected Object sort;
    protected String _sortType;
    protected Object page;
    protected Integer _pageType;
    protected Object limit;
    protected Integer _limitType;
    protected Object state;
    protected KindlingUserState _stateType;
    protected Object associatedWithCategoryId;
    protected Integer _associatedWithCategoryIdType;
    protected Object digest;
    protected KindlingUserDigest _digestType;
    protected Object query;
    protected String _queryType;
    protected Object reputationTimeframe;
    protected KindlingUserReputationTimeframe _reputationTimeframeType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets limit
     * 
     * @param value Value to set
     */
    public void setLimit(Object value) {
        this.limit = value;
    }

    /**
     * Sets sort
     * 
     * @param value Value to set
     */
    public void setSort(Object value) {
        this.sort = value;
    }

    /**
     * Sets page
     * 
     * @param value Value to set
     */
    public void setPage(Object value) {
        this.page = value;
    }

    /**
     * Sets query
     * 
     * @param value Value to set
     */
    public void setQuery(Object value) {
        this.query = value;
    }

    /**
     * Sets reputationTimeframe
     * 
     * @param value Value to set
     */
    public void setReputationTimeframe(Object value) {
        this.reputationTimeframe = value;
    }

    /**
     * Sets state
     * 
     * @param value Value to set
     */
    public void setState(Object value) {
        this.state = value;
    }

    /**
     * Sets digest
     * 
     * @param value Value to set
     */
    public void setDigest(Object value) {
        this.digest = value;
    }

    /**
     * Sets associatedWithCategoryId
     * 
     * @param value Value to set
     */
    public void setAssociatedWithCategoryId(Object value) {
        this.associatedWithCategoryId = value;
    }

    /**
     * Sets depth
     * 
     * @param value Value to set
     */
    public void setDepth(Object value) {
        this.depth = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(KindlingConnectorConnectionManager.class, true, event);
            final Integer _transformedDepth = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_depthType").getGenericType(), null, depth));
            final String _transformedSort = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_sortType").getGenericType(), null, sort));
            final Integer _transformedPage = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_pageType").getGenericType(), null, page));
            final Integer _transformedLimit = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_limitType").getGenericType(), null, limit));
            final KindlingUserState _transformedState = ((KindlingUserState) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_stateType").getGenericType(), null, state));
            final Integer _transformedAssociatedWithCategoryId = ((Integer) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_associatedWithCategoryIdType").getGenericType(), null, associatedWithCategoryId));
            final KindlingUserDigest _transformedDigest = ((KindlingUserDigest) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_digestType").getGenericType(), null, digest));
            final String _transformedQuery = ((String) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_queryType").getGenericType(), null, query));
            final KindlingUserReputationTimeframe _transformedReputationTimeframe = ((KindlingUserReputationTimeframe) evaluateAndTransform(getMuleContext(), event, RetrieveUsersMessageProcessor.class.getDeclaredField("_reputationTimeframeType").getGenericType(), null, reputationTimeframe));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((KindlingConnector) object).retrieveUsers(_transformedDepth, _transformedSort, _transformedPage, _transformedLimit, _transformedState, _transformedAssociatedWithCategoryId, _transformedDigest, _transformedQuery, _transformedReputationTimeframe);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("retrieveUsers"), event, e);
        }
    }

}
