
package org.mule.module.kindling.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.kindling.KindlingConnector;
import org.mule.module.kindling.connectivity.KindlingConnectorConnectionManager;
import org.mule.module.kindling.model.idea.KindlingIdea;


/**
 * UpdateIdeaMessageProcessor invokes the {@link org.mule.module.kindling.KindlingConnector#updateIdea(java.lang.String, org.mule.module.kindling.model.idea.KindlingIdea)} method in {@link KindlingConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-08T03:29:54-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class UpdateIdeaMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object ideaId;
    protected String _ideaIdType;
    protected Object idea;
    protected KindlingIdea _ideaType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets idea
     * 
     * @param value Value to set
     */
    public void setIdea(Object value) {
        this.idea = value;
    }

    /**
     * Sets ideaId
     * 
     * @param value Value to set
     */
    public void setIdeaId(Object value) {
        this.ideaId = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(KindlingConnectorConnectionManager.class, true, event);
            final String _transformedIdeaId = ((String) evaluateAndTransform(getMuleContext(), event, UpdateIdeaMessageProcessor.class.getDeclaredField("_ideaIdType").getGenericType(), null, ideaId));
            final KindlingIdea _transformedIdea = ((KindlingIdea) evaluateAndTransform(getMuleContext(), event, UpdateIdeaMessageProcessor.class.getDeclaredField("_ideaType").getGenericType(), null, idea));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((KindlingConnector) object).updateIdea(_transformedIdeaId, _transformedIdea);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("updateIdea"), event, e);
        }
    }

}
