/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.kindling;

import org.mule.api.ConnectionException;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Optional;
import org.mule.module.kindling.client.KindlingClient;
import org.mule.module.kindling.client.authentication.impl.KindlingAuthenticationBasic;
import org.mule.module.kindling.client.impl.KindlingClientImpl;
import org.mule.module.kindling.exception.KindlingConnectorException;
import org.mule.module.kindling.exception.KindlingConnectorUnauthorizedException;
import org.mule.module.kindling.model.KindlingCollection;
import org.mule.module.kindling.model.category.KindlingCategory;
import org.mule.module.kindling.model.comment.KindlingComment;
import org.mule.module.kindling.model.comment.KindlingCommentParentType;
import org.mule.module.kindling.model.comment.KindlingCommentType;
import org.mule.module.kindling.model.group.KindlingGroup;
import org.mule.module.kindling.model.idea.KindlingIdea;
import org.mule.module.kindling.model.post.KindlingPost;
import org.mule.module.kindling.model.user.KindlingUser;
import org.mule.module.kindling.types.KindlingCategoryState;
import org.mule.module.kindling.types.KindlingIdeaFilter;
import org.mule.module.kindling.types.KindlingPostState;
import org.mule.module.kindling.types.KindlingState;
import org.mule.module.kindling.types.KindlingUserDigest;
import org.mule.module.kindling.types.KindlingUserReputationTimeframe;
import org.mule.module.kindling.types.KindlingUserState;

@Connector(name="kindling", schemaVersion="2.2", friendlyName="Kindling")
public class KindlingConnector {
    private KindlingClient client;

    @Connect
    public void connect(@ConnectionKey String username, String password, String companyName) throws ConnectionException {
        KindlingAuthenticationBasic auth = new KindlingAuthenticationBasic(username, password);
        this.client = new KindlingClientImpl(companyName, auth);
    }

    @Disconnect
    public void disconnect() {
        this.client = null;
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.client != null;
    }

    @ConnectionIdentifier
    public String connectionId() {
        return "001";
    }

    @Processor
    public KindlingCollection<KindlingGroup> retrieveGroups(@Optional Integer depth, @Optional String sort, @Optional Integer page, @Optional Integer limit, @Optional KindlingState state, @Optional String startsWith, @Optional String query) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveGroups(depth, sort, page, limit, state, startsWith, query);
    }

    @Processor
    public KindlingGroup retrieveGroup(String groupId, @Optional Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveGroup(groupId, depth);
    }

    @Processor
    public KindlingGroup updateGroup(String groupId, KindlingGroup group) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.updateGroup(groupId, group);
    }

    @Processor
    public KindlingGroup createGroup(KindlingGroup group) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.createGroup(group);
    }

    @Processor
    public KindlingCollection<KindlingComment> retrieveComments(KindlingCommentParentType parentType, @Optional Integer depth, @Optional String sort, @Optional Integer page, @Optional Integer limit, @Optional KindlingState state, @Optional Integer parentId, @Optional KindlingCommentType type) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveComments(parentType, depth, sort, page, limit, state, parentId, type);
    }

    @Processor
    public KindlingComment createComment(KindlingComment comment) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.createComment(comment);
    }

    @Processor
    public KindlingComment retrieveComment(String commentId, @Optional Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveComment(commentId, depth);
    }

    @Processor
    public void deleteComment(String commentId) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        this.client.deleteComment(commentId);
    }

    @Processor
    public KindlingCollection<KindlingIdea> retrieveIdeas(@Optional Integer depth, @Optional String sort, @Optional Integer page, @Optional Integer limit, @Optional String state, @Optional Boolean allowsVoting, @Optional String query, @Optional String authorId, @Optional String categoryId, @Optional KindlingIdeaFilter filter) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveIdeas(depth, sort, page, limit, state, allowsVoting, query, authorId, categoryId, filter);
    }

    @Processor
    public KindlingIdea createIdea(KindlingIdea idea) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.createIdea(idea);
    }

    @Processor
    public KindlingIdea retrieveIdea(String ideaId, @Optional Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveIdea(ideaId, depth);
    }

    @Processor
    public KindlingIdea updateIdea(String ideaId, KindlingIdea idea) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.updateIdea(ideaId, idea);
    }

    @Processor
    public KindlingCollection<KindlingUser> retrieveUsers(@Optional Integer depth, @Optional String sort, @Optional Integer page, @Optional Integer limit, @Optional KindlingUserState state, @Optional Integer associatedWithCategoryId, @Optional KindlingUserDigest digest, @Optional String query, @Optional KindlingUserReputationTimeframe reputationTimeframe) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveUsers(depth, sort, page, limit, state, associatedWithCategoryId, digest, query, reputationTimeframe);
    }

    @Processor
    public KindlingUser createUser(KindlingUser user) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.createUser(user);
    }

    @Processor
    public KindlingUser retrieveUser(String userId, @Optional Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveUser(userId, depth);
    }

    @Processor
    public KindlingUser updateUser(String userId, KindlingUser user) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.updateUser(userId, user);
    }

    @Processor
    public void deleteUser(String userId) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        this.client.deleteUser(userId);
    }

    @Processor
    public KindlingCollection<KindlingPost> retrievePosts(@Optional Integer depth, @Optional String sort, @Optional Integer page, @Optional Integer limit, @Optional KindlingPostState state, @Optional String startsWith, @Optional String query) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrievePosts(depth, sort, page, limit, state, startsWith, query);
    }

    @Processor
    public KindlingPost createPost(KindlingPost post) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.createPost(post);
    }

    @Processor
    public KindlingPost retrievePost(String postId, @Optional Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrievePost(postId, depth);
    }

    @Processor
    public KindlingPost updatePost(String postId, KindlingPost post) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.updatePost(postId, post);
    }

    @Processor
    public KindlingCollection<KindlingCategory> retrieveCategories(@Optional Integer depth, @Optional String sort, @Optional Integer page, @Optional Integer limit, @Optional KindlingCategoryState state, @Optional String query, @Optional Integer associatedWithUserId) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveCategories(depth, sort, page, limit, state, query, associatedWithUserId);
    }

    @Processor
    public KindlingCategory createCategory(KindlingCategory category) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.createCategory(category);
    }

    @Processor
    public KindlingCategory retrieveCategory(String categoryId, @Optional Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.retrieveCategory(categoryId, depth);
    }

    @Processor
    public KindlingCategory updateCategory(String categoryId, KindlingCategory category) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        return this.client.updateCategory(categoryId, category);
    }
}

