/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.kindling.client;

import com.sun.jersey.api.client.Client;
import javax.ws.rs.core.UriBuilder;
import org.mule.module.kindling.client.KindlingClient;
import org.mule.module.kindling.client.authentication.KindlingAuthentication;

public abstract class KindlingClientBase
implements KindlingClient {
    private static final String API_URL = "https://%s.kindlingapp.com/api/";
    private Client jerseyClient;
    private String loggedUser;
    private String companyName;
    private KindlingAuthentication authentication;

    public KindlingClientBase(String companyName, KindlingAuthentication authentication) {
        this.companyName = companyName;
        this.authentication = authentication;
        this.loggedUser = authentication.getUsername();
        this.jerseyClient = null;
    }

    protected synchronized Client getJerseyClient() {
        if (this.jerseyClient == null) {
            this.jerseyClient = this.authentication.generateClientAndAuthenticate();
        }
        return this.jerseyClient;
    }

    protected UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromPath((String)String.format(API_URL, this.companyName));
    }

    public String getLoggedUser() {
        return this.loggedUser;
    }
}

