/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.kindling.client.impl;

import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.type.JavaType;
import org.mule.module.kindling.client.KindlingClientBase;
import org.mule.module.kindling.client.KindlingClientUtils;
import org.mule.module.kindling.client.authentication.KindlingAuthentication;
import org.mule.module.kindling.exception.KindlingConnectorException;
import org.mule.module.kindling.exception.KindlingConnectorUnauthorizedException;
import org.mule.module.kindling.model.KindlingCollection;
import org.mule.module.kindling.model.category.KindlingCategory;
import org.mule.module.kindling.model.comment.KindlingComment;
import org.mule.module.kindling.model.comment.KindlingCommentParentType;
import org.mule.module.kindling.model.comment.KindlingCommentType;
import org.mule.module.kindling.model.group.KindlingGroup;
import org.mule.module.kindling.model.idea.KindlingIdea;
import org.mule.module.kindling.model.post.KindlingPost;
import org.mule.module.kindling.model.user.KindlingUser;
import org.mule.module.kindling.types.KindlingCategoryState;
import org.mule.module.kindling.types.KindlingIdeaFilter;
import org.mule.module.kindling.types.KindlingPostState;
import org.mule.module.kindling.types.KindlingState;
import org.mule.module.kindling.types.KindlingUserDigest;
import org.mule.module.kindling.types.KindlingUserReputationTimeframe;
import org.mule.module.kindling.types.KindlingUserState;
import org.mule.module.kindling.types.KindlingWebResourceMethods;

public class KindlingClientImpl
extends KindlingClientBase {
    private static final Log logger = LogFactory.getLog(KindlingClientImpl.class);

    public KindlingClientImpl(String companyName, KindlingAuthentication authentication) {
        super(companyName, authentication);
    }

    @Override
    public KindlingCollection<KindlingGroup> retrieveGroups(Integer depth, String sort, Integer page, Integer limit, KindlingState state, String startsWith, String query) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        URI uri = this.getBaseUriBuilder().path("groups").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        if (!StringUtils.isEmpty((String)sort)) {
            wr = wr.queryParam("sort", sort);
        }
        if (page != null && page > 1) {
            wr = wr.queryParam("page", String.valueOf(page));
        }
        if (limit != null && limit > 0) {
            wr = wr.queryParam("limit", String.valueOf(limit));
        }
        if (state != null) {
            wr = wr.queryParam("state", state.getValue());
        }
        if (!StringUtils.isEmpty((String)startsWith)) {
            wr = wr.queryParam("startsWith", startsWith);
        }
        if (!StringUtils.isEmpty((String)query)) {
            wr = wr.queryParam("q", query);
        }
        logger.info((Object)("Requesting retrieveGroups to: " + wr.toString()));
        JavaType type = KindlingClientUtils.constructKindlingCollectionType(KindlingGroup.class);
        return KindlingClientUtils.webResourceCallWithJavaType(type, KindlingCollection.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingGroup retrieveGroup(String groupId, Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)groupId)) {
            throw new KindlingConnectorException("The groupId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("groups/{groupId}").build(new Object[]{groupId});
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        logger.info((Object)("Requesting retrieveGroup to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingGroup.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingGroup updateGroup(String groupId, KindlingGroup group) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)groupId)) {
            throw new KindlingConnectorException("The groupId parameter it's required");
        }
        if (group == null) {
            throw new KindlingConnectorException("The group parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("groups/{groupId}").build(new Object[]{groupId});
        WebResource wr = this.getJerseyClient().resource(uri);
        String groupJson = KindlingClientUtils.transformObjectToJson(group);
        logger.info((Object)("Requesting updateGroup to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingGroup.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.PUT, groupJson);
    }

    @Override
    public KindlingGroup createGroup(KindlingGroup group) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (group == null) {
            throw new KindlingConnectorException("The group parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("groups").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        String groupJson = KindlingClientUtils.transformObjectToJson(group);
        logger.info((Object)("Requesting createGroup to: " + wr.toString()));
        return (KindlingGroup)KindlingClientUtils.webResourceCallWithClassType(null, wr, this.getLoggedUser(), KindlingWebResourceMethods.POST, groupJson);
    }

    @Override
    public KindlingCollection<KindlingComment> retrieveComments(KindlingCommentParentType parentType, Integer depth, String sort, Integer page, Integer limit, KindlingState state, Integer parentId, KindlingCommentType type) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (parentType == null) {
            throw new KindlingConnectorException("The parentType parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("comments").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        wr = wr.queryParam("parentType", parentType.getValue());
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        if (!StringUtils.isEmpty((String)sort)) {
            wr = wr.queryParam("sort", sort);
        }
        if (page != null && page > 1) {
            wr = wr.queryParam("page", String.valueOf(page));
        }
        if (limit != null && limit > 0) {
            wr = wr.queryParam("limit", String.valueOf(limit));
        }
        if (state != null) {
            wr = wr.queryParam("state", state.getValue());
        }
        if (parentId != null && parentId > 0) {
            wr = wr.queryParam("parentId", String.valueOf(parentId));
        }
        if (type != null) {
            wr = wr.queryParam("type", type.getValue());
        }
        logger.info((Object)("Requesting getComments to: " + wr.toString()));
        JavaType jtype = KindlingClientUtils.constructKindlingCollectionType(KindlingComment.class);
        return KindlingClientUtils.webResourceCallWithJavaType(jtype, KindlingCollection.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingComment createComment(KindlingComment comment) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (comment == null) {
            throw new KindlingConnectorException("The comment parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("comments").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        String commentJson = KindlingClientUtils.transformObjectToJson(comment);
        logger.info((Object)("Requesting createComment to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingComment.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.POST, commentJson);
    }

    @Override
    public KindlingComment retrieveComment(String commentId, Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)commentId)) {
            throw new KindlingConnectorException("The commentId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("comments/{commentId}").build(new Object[]{commentId});
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        logger.info((Object)("Requesting retrieveComment to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingComment.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public void deleteComment(String commentId) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)commentId)) {
            throw new KindlingConnectorException("The commentId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("comments/{commentId}").build(new Object[]{commentId});
        WebResource wr = this.getJerseyClient().resource(uri);
        logger.info((Object)("Requesting deleteComment to: " + wr.toString()));
        KindlingClientUtils.webResourceCall(wr, this.getLoggedUser(), KindlingWebResourceMethods.DELETE);
    }

    @Override
    public KindlingCollection<KindlingIdea> retrieveIdeas(Integer depth, String sort, Integer page, Integer limit, String state, Boolean allowsVoting, String query, String authorId, String categoryId, KindlingIdeaFilter filter) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        URI uri = this.getBaseUriBuilder().path("ideas").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        if (!StringUtils.isEmpty((String)sort)) {
            wr = wr.queryParam("sort", sort);
        }
        if (page != null && page > 1) {
            wr = wr.queryParam("page", String.valueOf(page));
        }
        if (limit != null && limit > 0) {
            wr = wr.queryParam("limit", String.valueOf(limit));
        }
        if (!StringUtils.isEmpty((String)state)) {
            wr = wr.queryParam("state", state);
        }
        if (allowsVoting != null) {
            wr = wr.queryParam("allowsVoting", String.valueOf(allowsVoting));
        }
        if (!StringUtils.isEmpty((String)query)) {
            wr = wr.queryParam("q", query);
        }
        if (!StringUtils.isEmpty((String)authorId)) {
            wr = wr.queryParam("authorId", authorId);
        }
        if (!StringUtils.isEmpty((String)categoryId)) {
            wr = wr.queryParam("categoryId", categoryId);
        }
        if (filter != null) {
            wr = wr.queryParam("filter", filter.getValue());
        }
        logger.info((Object)("Requesting retrieveIdeas to: " + wr.toString()));
        JavaType jtype = KindlingClientUtils.constructKindlingCollectionType(KindlingIdea.class);
        return KindlingClientUtils.webResourceCallWithJavaType(jtype, KindlingCollection.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingIdea createIdea(KindlingIdea idea) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (idea == null) {
            throw new KindlingConnectorException("The idea parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("ideas").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        String ideaJson = KindlingClientUtils.transformObjectToJson(idea);
        logger.info((Object)("Requesting createIdea to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingIdea.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.POST, ideaJson);
    }

    @Override
    public KindlingIdea retrieveIdea(String ideaId, Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)ideaId)) {
            throw new KindlingConnectorException("The ideaId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("ideas/{ideaId}").build(new Object[]{ideaId});
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        logger.info((Object)("Requesting retrieveIdea to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingIdea.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingIdea updateIdea(String ideaId, KindlingIdea idea) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)ideaId)) {
            throw new KindlingConnectorException("The ideaId parameter it's required");
        }
        if (idea == null) {
            throw new KindlingConnectorException("The idea parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("ideas/{ideaId}").build(new Object[]{ideaId});
        WebResource wr = this.getJerseyClient().resource(uri);
        logger.info((Object)("Requesting updateIdea to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingIdea.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.PUT);
    }

    @Override
    public KindlingCollection<KindlingUser> retrieveUsers(Integer depth, String sort, Integer page, Integer limit, KindlingUserState state, Integer associatedWithCategoryId, KindlingUserDigest digest, String query, KindlingUserReputationTimeframe reputationTimeframe) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        URI uri = this.getBaseUriBuilder().path("users").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        if (!StringUtils.isEmpty((String)sort)) {
            wr = wr.queryParam("sort", sort);
        }
        if (page != null && page > 1) {
            wr = wr.queryParam("page", String.valueOf(page));
        }
        if (limit != null && limit > 0) {
            wr = wr.queryParam("limit", String.valueOf(limit));
        }
        if (state != null) {
            wr = wr.queryParam("state", state.getValue());
        }
        if (associatedWithCategoryId != null && associatedWithCategoryId > 0) {
            wr = wr.queryParam("associatedWithCategoryId", String.valueOf(associatedWithCategoryId));
        }
        if (digest != null) {
            wr = wr.queryParam("hasDigests", digest.getValue());
        }
        if (!StringUtils.isEmpty((String)query)) {
            wr = wr.queryParam("q", query);
        }
        if (reputationTimeframe != null) {
            wr = wr.queryParam("reputationTimeframe", reputationTimeframe.getValue());
        }
        logger.info((Object)("Requesting retrieveUsers to: " + wr.toString()));
        JavaType jtype = KindlingClientUtils.constructKindlingCollectionType(KindlingUser.class);
        return KindlingClientUtils.webResourceCallWithJavaType(jtype, KindlingCollection.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingUser createUser(KindlingUser user) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (user == null) {
            throw new KindlingConnectorException("The user parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("users").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        String userJson = KindlingClientUtils.transformObjectToJson(user);
        logger.info((Object)("Requesting createUser to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingUser.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.POST, userJson);
    }

    @Override
    public KindlingUser retrieveUser(String userId, Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (userId == null) {
            throw new KindlingConnectorException("The userId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("users/{userId}").build(new Object[]{userId});
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        logger.info((Object)("Requesting retrieveUser to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingUser.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingUser updateUser(String userId, KindlingUser user) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)userId)) {
            throw new KindlingConnectorException("The userId parameter it's required");
        }
        if (user == null) {
            throw new KindlingConnectorException("The user parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("users/{userId}").build(new Object[]{userId});
        WebResource wr = this.getJerseyClient().resource(uri);
        String userJson = KindlingClientUtils.transformObjectToJson(user);
        logger.info((Object)("Requesting updateUser to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingUser.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.PUT, userJson);
    }

    @Override
    public void deleteUser(String userId) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)userId)) {
            throw new KindlingConnectorException("The userId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("users/{userId}").build(new Object[]{userId});
        WebResource wr = this.getJerseyClient().resource(uri);
        logger.info((Object)("Requesting deleteUser to: " + wr.toString()));
        KindlingClientUtils.webResourceCall(wr, this.getLoggedUser(), KindlingWebResourceMethods.DELETE);
    }

    @Override
    public KindlingCollection<KindlingCategory> retrieveCategories(Integer depth, String sort, Integer page, Integer limit, KindlingCategoryState state, String query, Integer associatedWithUserId) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        URI uri = this.getBaseUriBuilder().path("categories").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        if (!StringUtils.isEmpty((String)sort)) {
            wr = wr.queryParam("sort", sort);
        }
        if (page != null && page > 1) {
            wr = wr.queryParam("page", String.valueOf(page));
        }
        if (limit != null && limit > 0) {
            wr = wr.queryParam("limit", String.valueOf(limit));
        }
        if (state != null) {
            wr = wr.queryParam("state", state.getValue());
        }
        if (!StringUtils.isEmpty((String)query)) {
            wr = wr.queryParam("q", query);
        }
        if (associatedWithUserId != null && associatedWithUserId > 0) {
            wr = wr.queryParam("associatedWithUserId", String.valueOf(associatedWithUserId));
        }
        logger.info((Object)("Requesting retrieveCategories to: " + wr.toString()));
        JavaType jtype = KindlingClientUtils.constructKindlingCollectionType(KindlingCategory.class);
        return KindlingClientUtils.webResourceCallWithJavaType(jtype, KindlingCollection.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingCategory createCategory(KindlingCategory category) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (category == null) {
            throw new KindlingConnectorException("The category parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("categories").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        String categoryJson = KindlingClientUtils.transformObjectToJson(category);
        logger.info((Object)("Requesting createCategory to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingCategory.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.POST, categoryJson);
    }

    @Override
    public KindlingCategory retrieveCategory(String categoryId, Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)categoryId)) {
            throw new KindlingConnectorException("The categoryId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("categories/{categoryId}").build(new Object[]{categoryId});
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        logger.info((Object)("Requesting retrieveCategory to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingCategory.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingCategory updateCategory(String categoryId, KindlingCategory category) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)categoryId)) {
            throw new KindlingConnectorException("The categoryId parameter it's required");
        }
        if (category == null) {
            throw new KindlingConnectorException("The category parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("categories/{categoryId}").build(new Object[]{categoryId});
        WebResource wr = this.getJerseyClient().resource(uri);
        String categoryJson = KindlingClientUtils.transformObjectToJson(category);
        logger.info((Object)("Requesting updateCategory to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingCategory.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.PUT, categoryJson);
    }

    @Override
    public KindlingCollection<KindlingPost> retrievePosts(Integer depth, String sort, Integer page, Integer limit, KindlingPostState state, String startsWith, String query) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        URI uri = this.getBaseUriBuilder().path("posts").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null && depth > 0) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        if (!StringUtils.isEmpty((String)sort)) {
            wr = wr.queryParam("sort", sort);
        }
        if (page != null && page > 1) {
            wr = wr.queryParam("page", String.valueOf(page));
        }
        if (limit != null && limit > 0) {
            wr = wr.queryParam("limit", String.valueOf(limit));
        }
        if (state != null) {
            wr = wr.queryParam("state", state.getValue());
        }
        if (!StringUtils.isEmpty((String)query)) {
            wr = wr.queryParam("q", query);
        }
        logger.info((Object)("Requesting retrievePosts to: " + wr.toString()));
        JavaType jtype = KindlingClientUtils.constructKindlingCollectionType(KindlingPost.class);
        return KindlingClientUtils.webResourceCallWithJavaType(jtype, KindlingCollection.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingPost retrievePost(String postId, Integer depth) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (postId == null) {
            throw new KindlingConnectorException("The postId parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("posts/{postId}").build(new Object[]{postId});
        WebResource wr = this.getJerseyClient().resource(uri);
        if (depth != null) {
            wr = wr.queryParam("depth", String.valueOf(depth));
        }
        logger.info((Object)("Requesting retrievePost to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingPost.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.GET);
    }

    @Override
    public KindlingPost updatePost(String postId, KindlingPost post) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (StringUtils.isEmpty((String)postId)) {
            throw new KindlingConnectorException("The postId parameter it's required");
        }
        if (post == null) {
            throw new KindlingConnectorException("The post parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("post/{postId}").build(new Object[]{postId});
        WebResource wr = this.getJerseyClient().resource(uri);
        String userJson = KindlingClientUtils.transformObjectToJson(post);
        logger.info((Object)("Requesting updatePost to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingPost.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.PUT, userJson);
    }

    @Override
    public KindlingPost createPost(KindlingPost post) throws KindlingConnectorException, KindlingConnectorUnauthorizedException {
        if (post == null) {
            throw new KindlingConnectorException("The post parameter it's required");
        }
        URI uri = this.getBaseUriBuilder().path("posts").build(new Object[0]);
        WebResource wr = this.getJerseyClient().resource(uri);
        String userJson = KindlingClientUtils.transformObjectToJson(post);
        logger.info((Object)("Requesting createPost to: " + wr.toString()));
        return KindlingClientUtils.webResourceCallWithClassType(KindlingPost.class, wr, this.getLoggedUser(), KindlingWebResourceMethods.POST, userJson);
    }
}

