/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 **/

/**
 * This file was automatically generated by the Mule Development Kit
 */
package org.mule.module.successfactors;

import java.util.List;

import javax.activation.DataHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.module.successfactors.api.SuccessFactorsClientBase;
import org.mule.module.successfactors.api.SuccessFactorsClientImpl;
import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

import com.successfactors.sfapi.sfobject.DeleteResult;
import com.successfactors.sfapi.sfobject.DescribeResult;
import com.successfactors.sfapi.sfobject.DescribeSFObjects;
import com.successfactors.sfapi.sfobject.GetJobResult;
import com.successfactors.sfapi.sfobject.InsertResult;
import com.successfactors.sfapi.sfobject.QueryResult;
import com.successfactors.sfapi.sfobject.SFObject;
import com.successfactors.sfapi.sfobject.SFParameter;
import com.successfactors.sfapi.sfobject.TaskStatus;
import com.successfactors.sfapi.sfobject.UpdateResult;
import com.successfactors.sfapi.sfobject.UpsertResult;

/**
 * Success Factors Connector
 * 
 * This connector allows to integrate the Success Factor service.
 * 
 * It covers all the service provided by SF. This is a generic service that enforces the use of Entities in all the major operations and
 * query consults in SFQL (Success Factors Query Language).
 * 
 * Also has a separate set of operations to work with asynchronous jobs.
 *
 * @author MuleSoft, Inc.
 */
@Connector(name="successfactors", schemaVersion="1.0", friendlyName="Success Factors")
public class SuccessFactorsConnector
{
	
	static private final Log logger = LogFactory.getLog(SuccessFactorsConnector.class);
	
	/**
	 * The wsdl location of the service definition.
	 * The connector is working with the 1.1 SOAP specification endpoint.
	 */
	@Configurable
	private String wsdlLocation;
		
	/**
	 * The companyId used to access the SF service
	 */
	@Configurable
	private String companyId;
	
	private SuccessFactorsClientBase client;
	
	public String getWsdlLocation() {
		return wsdlLocation;
	}

	public void setWsdlLocation(String wsdlLocation) {
		this.wsdlLocation = wsdlLocation;
	}

	public SuccessFactorsClientBase getClient() {
		return client;
	}

	public void setClient(SuccessFactorsClientBase client) {
		this.client = client;
	}
	
	public String getCompanyId() {
		return companyId;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}
	
	/**
	  * Connect
	  *
	  * @param username A username
	  * @param password A password
	  * @throws ConnectionException
	  */
	 @Connect
	 public void connect(@ConnectionKey String username, String password)
	     throws ConnectionException {
	    
		// This verification is for the test cases when a mocked client is injected
		if (client == null) {
			client = new SuccessFactorsClientImpl(wsdlLocation, companyId, username, password);
			try {
				client.initClient();
				client.login(null);
			} catch (SuccessFactorsConnectorException e) {
				throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", e.getMessage(), e);
			}
		}
	 }
	
	 /**
	  * Disconnect
	  */
	 @Disconnect
	 public void disconnect() {
	     if (client != null) {
	    	 try {
				client.logout();
			} catch (SuccessFactorsConnectorException e) {
				logger.debug("Error trying to logout from Success Factors service for user " + client.getUsername());
			}
	    	
	    	client.release();
	    	client = null;
	     }
	 }
	
	 /**
	  * Are we connected
	  */
	 @ValidateConnection
	 public boolean isConnected() {
	     return client != null;		 
	 }
	
	 /**
	  * Are we connected
	  */
	 @ConnectionIdentifier
	 public String connectionId() {
	     return client.getUsername();
	 }
	
	/**
	 * List all the entities in your company instance.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:list-entities}
	 * 
	 * @return A list of String that contains the names of the entities
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public List<String> listEntities() throws SuccessFactorsConnectorException {
		return client.listEntities();
	}
	
	/**
	 * Returns metadata about the list of entities specified in the type parameter (both field and entity information).
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:describe-entities}
	 * 
	 * @param params The list of entities from which you want to obtain detailed information
	 * @return A list of DescribeResult that has detailed information of each entity
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public List<DescribeResult> describeEntities(DescribeSFObjects params) throws SuccessFactorsConnectorException {
		return client.describeEntities(params);
	}
	
	/**
	 * Inserts the objects of the specified entity type. The operation will resume if one row has failed to insert.
	 *  
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:insert}
	 *  
	 * @param type The entity type to be inserted
	 * @param objects A list of entities to be inserted
	 * @param processingParams Extra parameters for configuration
	 * @return The result of the operation
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public InsertResult insert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
		return client.insert(type, objects, processingParams);
	}
	
	/**
	 * Updates the objects of the specified entity type. The operation will resume if one row has failed to update.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:update}
	 * 
	 * @param type The entity type to be updated
	 * @param objects A list of entities to be updated
	 * @param processingParams Extra parameters for configuration
	 * @return  The result of the operation
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public UpdateResult update(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
		return client.update(type, objects, processingParams);
	}
	
	/**
	 * Inserts or updates the objects of the specified entity type. If the row doesn't exist, perform the insert operation, if the row exists, 
	 * perform the update operation. The operation will resume if one row has failed to upsert.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:upsert}
	 * 
	 * @param type The entity type to be upserted
	 * @param objects A list of entities to be upserted
	 * @param processingParams Extra parameters for configuration
	 * @return The result of the operation
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public UpsertResult upsert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
		return client.upsert(type, objects, processingParams);
	}
	
	/**
	 * Deletes the SFObjects specified by the type and the objects. The operation will resume if one row has failed to delete.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:delete}
	 * 
	 * @param type The entity type to be deleted
	 * @param objects A list of entities to be deleted
	 * @param processingParams Extra parameters for configuration
	 * @return The result of the operation
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public DeleteResult delete(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
		return client.delete(type, objects, processingParams);
	}
		
	/**
	 * Queries the SuccessFactors platform with the given query string in SFQL (SuccessFactors Query Language). 
	 * For a detailed grammar description, please check the related section in this reference guide.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:query}
	 * 
	 * @param queryString The query in SFQL format
	 * @param params Extra parameters for configuration
	 * @return The result of the query
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public QueryResult query(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException {
		return client.query(queryString, params);
	}
	
	/**
	 * The queryMore call is provided to support paging. It requires a querySessionId to identify the next page of results. 
	 * The querySessionId is a parameter of the QueryResult object, obtained from a previous call to either the query or queryMore operation.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:query-more}
	 * 
	 * @param querySessionId The querySessionId that came as result of query or queryMore operations
	 * @return The result of the query
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public QueryResult queryMore(String querySessionId) throws SuccessFactorsConnectorException {
		return client.queryMore(querySessionId);
	}
	
	/**
	 * Submit the asynchronous query job to the SuccessFactors platform with the given query string in SFQL (SuccessFactors Query Language). 
	 * TaskStatus includes “taskId” which is used to identify a submitted job.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:submit-query-job}
	 * 
	 * @param queryString The query in SFQL format
	 * @param params Extra parameters for configuration
	 * @return The status of the task created
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public TaskStatus submitQueryJob(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException {
		return client.submitQueryJob(queryString, params);
	}
	
	/**
	 * Get the execution status of the submitted asynchronous job.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:get-job-status}
	 * 
	 * @param taskId The id of the task to obtain the status information 
	 * @return The status of the task requested
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public TaskStatus getJobStatus(String taskId) throws SuccessFactorsConnectorException {
		return client.getJobStatus(taskId);
	}
	
	/**
	 * Download the result of submitted asynchronous query job. 
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:get-job-result}
	 * 
	 * @param params Extra parameters for configuration
	 * @return A DataHandler to obtain the information generated by the task
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public DataHandler getJobResult(GetJobResult params) throws SuccessFactorsConnectorException {
		return client.getJobResult(params);
	}
	
	/**
	 * List all Jobs which are in running or waiting to run.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:list-jobs}
	 * 
	 * @return A list with the status of all the Jobs
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public List<TaskStatus> listJobs() throws SuccessFactorsConnectorException {
		return client.listJobs();
	}
	
	/**
	 * Download the result of submitted asynchronous query job.
	 * 
	 * {@sample.xml ../../../doc/SuccessFactors-connector.xml.sample successfactors:cancel-job}
	 * 
	 * @param taskId The id of the task to cancel the execution
	 * @return The status of the task stopped
	 * @throws SuccessFactorsConnectorException If any error occurs throw this exception with a personalized code and message for each case.
	 */
	@Processor
	public TaskStatus cancelJob(String taskId) throws SuccessFactorsConnectorException {
		return client.cancelJob(taskId);
	}
}
