/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.successfactors.api;

import java.util.List;

import javax.activation.DataHandler;

import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

import com.successfactors.sfapi.sfobject.DeleteResult;
import com.successfactors.sfapi.sfobject.DescribeResult;
import com.successfactors.sfapi.sfobject.DescribeSFObjects;
import com.successfactors.sfapi.sfobject.GetJobResult;
import com.successfactors.sfapi.sfobject.InsertResult;
import com.successfactors.sfapi.sfobject.QueryResult;
import com.successfactors.sfapi.sfobject.SFObject;
import com.successfactors.sfapi.sfobject.SFParameter;
import com.successfactors.sfapi.sfobject.TaskStatus;
import com.successfactors.sfapi.sfobject.UpdateResult;
import com.successfactors.sfapi.sfobject.UpsertResult;

public interface SuccessFactorsClient {

	void initClient() throws SuccessFactorsConnectorException;
	
	// Session management operations	
	void login(List<SFParameter> params) 	throws SuccessFactorsConnectorException;	
	boolean logout() 						throws SuccessFactorsConnectorException;
	boolean isValidSession() 				throws SuccessFactorsConnectorException;
	
	// MetaData Operations
	List<String> listEntities() 									throws SuccessFactorsConnectorException;
	List<DescribeResult> describeEntities(DescribeSFObjects params) throws SuccessFactorsConnectorException;
	
	// Data Manipulation
	InsertResult insert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException;
	UpdateResult update(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException;
	UpsertResult upsert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException;
	DeleteResult delete(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException;
	
	// Data Query Operations
	QueryResult query(String queryString, List<SFParameter> params) 	throws SuccessFactorsConnectorException;
	QueryResult queryMore(String querySessionId) 						throws SuccessFactorsConnectorException;
	
	// Async Job Operations
	TaskStatus submitQueryJob(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException;
	TaskStatus getJobStatus(String taskId) 									throws SuccessFactorsConnectorException;
	DataHandler getJobResult(GetJobResult params)	 						throws SuccessFactorsConnectorException;
	List<TaskStatus> listJobs() 											throws SuccessFactorsConnectorException;
	TaskStatus cancelJob(String taskId) 									throws SuccessFactorsConnectorException;
}
