/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.successfactors.api;

import java.net.MalformedURLException;
import java.net.URL;

import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

import com.successfactors.sfapi.server.SFAPI;
import com.successfactors.sfapi.server.SFAPIService;

/**
 * Base class for all the SuccessFactorsClient implementations that handles the Asynchronous request of a new service.
 */
abstract public class SuccessFactorsClientBase implements SuccessFactorsClient {
	
	static private SFAPIService service;
	static private Object serviceLock;
	
	static
	{
		serviceLock = new Object();
		service = null;
	}
	
	protected String wsdlLocation;
	protected String companyId;
	protected String username;
	protected String password;
	
	
	public SuccessFactorsClientBase(String wsdlLocation, String companyId, String username, String password) {
		this.wsdlLocation = wsdlLocation;
		this.companyId = companyId;
		this.username = username;
		this.password = password;
	}
	
	public String getCompanyId() { return companyId; }

	public String getUsername() { return username; }

	public String getWsdlLocation() { return wsdlLocation; }
	
	/**
	 * Returns a new instance of the client.
	 * This is generated from a Singleton service that is created in a thread-safe manner.
	 *   
	 * @return The instance of the SFAPI client
	 * @throws SuccessFactorsConnectorException If cannot create the Singleton service (only the first request of a new client can trigger this exception)
	 */
	protected SFAPI getClientInstance() throws SuccessFactorsConnectorException{
		// We only need one instance of the service to get a number of clients
		synchronized (SuccessFactorsClientBase.serviceLock) {
			if (SuccessFactorsClientBase.service == null) {
				try {
					SuccessFactorsClientBase.service = new SFAPIService(new URL(wsdlLocation));
				} catch (MalformedURLException e) {
					throw new SuccessFactorsConnectorException("ERROR. Cannot create the service beacuse the wsdl URL is malformed", e);
				}				
			}
		}
		
		return service.getSFAPI();
	}
	
	// Used to release the references of the attributes used by the Client
	public void release() {
		wsdlLocation 	= null;
		companyId 		= null;
		username 		= null;
		password 		= null;
	}
}
