/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.successfactors.api;

import java.util.List;

import javax.activation.DataHandler;
import javax.xml.ws.BindingProvider;

import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

import com.successfactors.sfapi.server.SFAPI;
import com.successfactors.sfapi.server.SFWebServiceFaultException;
import com.successfactors.sfapi.sfobject.DeleteResult;
import com.successfactors.sfapi.sfobject.DescribeResult;
import com.successfactors.sfapi.sfobject.DescribeSFObjects;
import com.successfactors.sfapi.sfobject.DescribeSFObjectsResponse;
import com.successfactors.sfapi.sfobject.Error;
import com.successfactors.sfapi.sfobject.GetJobResult;
import com.successfactors.sfapi.sfobject.InsertResult;
import com.successfactors.sfapi.sfobject.ListSFObjects;
import com.successfactors.sfapi.sfobject.ListSFObjectsResponse;
import com.successfactors.sfapi.sfobject.LoginResult;
import com.successfactors.sfapi.sfobject.QueryResult;
import com.successfactors.sfapi.sfobject.SFCredential;
import com.successfactors.sfapi.sfobject.SFObject;
import com.successfactors.sfapi.sfobject.SFParameter;
import com.successfactors.sfapi.sfobject.TaskStatus;
import com.successfactors.sfapi.sfobject.UpdateResult;
import com.successfactors.sfapi.sfobject.UpsertResult;

public class SuccessFactorsClientImpl extends SuccessFactorsClientBase {

	protected String sessionId;
	private SFAPI client;
		
	public SuccessFactorsClientImpl(String wsdlLocation, String companyId, String username, String password) {
		super(wsdlLocation, companyId, username, password);
		sessionId = null;
		client = null;
	}
	
	public String getSessionId() { return sessionId; }
	

	@Override
	public void initClient() throws SuccessFactorsConnectorException {
		if (client == null) {
			// Get a new instance of the client
			client = super.getClientInstance();
			
			// Need to set the property to maintain the http session
			((BindingProvider) client).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
		}
	}


	@Override
	public void login(List<SFParameter> params)
			throws SuccessFactorsConnectorException {
		
		SFCredential credentials = new SFCredential();
		credentials.setCompanyId(companyId);
		credentials.setUsername(username);
		credentials.setPassword(password);
		
		LoginResult lr = null;
		
		try {
			lr = client.login(credentials, params);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
		
		
		if (lr.getErrors() != null && lr.getErrors().size() > 0) {
			Error err = lr.getErrors().get(0);
			if (err != null) {
				throw new SuccessFactorsConnectorException(err.getErrorCode(), err.getErrorMessage());
			} else {
				throw new SuccessFactorsConnectorException("ERROR. Unknown authentication problem");
			}
		}
		
//		 The authentication process was successfully made
//		 sessionId = lr.getSessionId();
//		
//		 The SessionId comes in a cookie session, so the service suppose to add it manually to the headers
	}


	@Override
	public boolean logout() throws SuccessFactorsConnectorException {
		try {
			return client.logout();
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}


	@Override
	public boolean isValidSession() throws SuccessFactorsConnectorException {
		if (sessionId == null)
			return false;
		
		try {
			return client.isValidSession();
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}	
	}

	@Override
	public void release() {
		super.release();
				
		sessionId 	= null;
		client 		= null;
	}
	
	@Override
	public List<String> listEntities() throws SuccessFactorsConnectorException {
		ListSFObjectsResponse list = null;
		try {
			list = client.list(new ListSFObjects());
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
		
		return list.getNames();
	}


	@Override
	public List<DescribeResult> describeEntities(DescribeSFObjects params)
			throws SuccessFactorsConnectorException {
		
		DescribeSFObjectsResponse dr = null;
		
		try {
			dr = client.describe(params);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
		
		return dr.getResults();
	}

	@Override
	public InsertResult insert(String type, List<SFObject> objects,
			List<SFParameter> processingParams)
			throws SuccessFactorsConnectorException {

		try {
			return client.insert(type, objects, processingParams);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}		
	}

	@Override
	public UpdateResult update(String type, List<SFObject> objects,
			List<SFParameter> processingParams)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.update(type, objects, processingParams);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public UpsertResult upsert(String type, List<SFObject> objects,
			List<SFParameter> processingParams)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.upsert(type, objects, processingParams);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public DeleteResult delete(String type, List<SFObject> objects,
			List<SFParameter> processingParams)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.delete(type, objects, processingParams);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public QueryResult query(String queryString, List<SFParameter> params)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.query(queryString, params);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public QueryResult queryMore(String querySessionId)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.queryMore(querySessionId);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}
	
	@Override
	public TaskStatus submitQueryJob(String queryString, List<SFParameter> params) 
			throws SuccessFactorsConnectorException {
		
		try {
			return client.submitQueryJob(queryString, params);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public TaskStatus getJobStatus(String taskId)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.getJobStatus(taskId);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public DataHandler getJobResult(GetJobResult params)
			throws SuccessFactorsConnectorException {
		
		try {
			return client.getJobResult(params);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public List<TaskStatus> listJobs() throws SuccessFactorsConnectorException {
		try {
			return client.listJobs();
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

	@Override
	public TaskStatus cancelJob(String taskId)
			throws SuccessFactorsConnectorException {
		try {
			return client.cancelJob(taskId);
		} catch (SFWebServiceFaultException e) {
			throw new SuccessFactorsConnectorException(e.getFaultInfo(), e);
		}
	}

}
