/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.successfactors.execptions;

import com.successfactors.sfapi.fault.SFWebServiceFault;

public class SuccessFactorsConnectorException extends Exception {

	static private String transformFaultInfoToString(SFWebServiceFault faultInfo) {
		if (faultInfo != null) {
			return String.format("ERROR. Code [%s] Message: %s", faultInfo.getErrorCode(), faultInfo.getErrorMessage());
		} else {
			return "ERROR. Missing faultInfo...";
		}
	}
	
	private static final long serialVersionUID = 1L;
	
	public SuccessFactorsConnectorException(SFWebServiceFault faultInfo) {
		super(transformFaultInfoToString(faultInfo));
	}
	
	public SuccessFactorsConnectorException(SFWebServiceFault faultInfo, Throwable cause) {
		super(transformFaultInfoToString(faultInfo), cause);
	}
	
	public SuccessFactorsConnectorException(String errorCode, String errorMessage) {
		super(String.format("ERROR. Code [%s] Message: %s", errorCode, errorMessage));
	}
	
	public SuccessFactorsConnectorException(String message) {
		super(message);
	}
	
	public SuccessFactorsConnectorException(String message, Throwable cause) {
		super(message, cause);
	}
}
