/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.successfactors.execptions;

import com.successfactors.sfapi.fault.SFWebServiceFault;

public class SuccessFactorsConnectorSessionExpiredException extends Exception {
	
	static private String transformFaultInfoToString(SFWebServiceFault faultInfo) {
		if (faultInfo != null) {
			return String.format("ERROR. Code [%s] Message: %s", faultInfo.getErrorCode(), faultInfo.getErrorMessage());
		} else {
			return "ERROR. Missing faultInfo...";
		}
	}
	
	private static final long serialVersionUID = 1L;
	
	public SuccessFactorsConnectorSessionExpiredException(SFWebServiceFault faultInfo) {
		super(transformFaultInfoToString(faultInfo));
	}
	
	public SuccessFactorsConnectorSessionExpiredException(SFWebServiceFault faultInfo, Throwable cause) {
		super(transformFaultInfoToString(faultInfo), cause);
	}
	
	public SuccessFactorsConnectorSessionExpiredException(String errorCode, String errorMessage) {
		super(String.format("ERROR. Code [%s] Message: %s", errorCode, errorMessage));
	}
	
	public SuccessFactorsConnectorSessionExpiredException(String message) {
		super(message);
	}
	
	public SuccessFactorsConnectorSessionExpiredException(String message, Throwable cause) {
		super(message, cause);
	}
}
