
package org.mule.module.successfactors.processors;

import java.util.List;
import javax.annotation.Generated;
import com.successfactors.sfapi.sfobject.SFParameter;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.successfactors.SuccessFactorsConnector;
import org.mule.module.successfactors.connectivity.SuccessFactorsConnectorConnectionManager;


/**
 * QueryMessageProcessor invokes the {@link org.mule.module.successfactors.SuccessFactorsConnector#query(java.lang.String, java.util.List)} method in {@link SuccessFactorsConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.1", date = "2012-12-18T05:44:26-03:00", comments = "Build UNNAMED.1297.150f2c9")
public class QueryMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object queryString;
    protected String _queryStringType;
    protected Object params;
    protected List<SFParameter> _paramsType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets queryString
     * 
     * @param value Value to set
     */
    public void setQueryString(Object value) {
        this.queryString = value;
    }

    /**
     * Sets params
     * 
     * @param value Value to set
     */
    public void setParams(Object value) {
        this.params = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        try {
            findOrCreate(SuccessFactorsConnectorConnectionManager.class, false, event);
            final String _transformedQueryString = ((String) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_queryStringType").getGenericType(), null, queryString));
            final List<SFParameter> _transformedParams = ((List<SFParameter> ) evaluateAndTransform(getMuleContext(), event, QueryMessageProcessor.class.getDeclaredField("_paramsType").getGenericType(), null, params));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((SuccessFactorsConnector) object).query(_transformedQueryString, _transformedParams);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("query"), event, e);
        }
    }

}
