
package org.mule.module.successfactors.processors;

import java.util.List;
import javax.annotation.Generated;
import com.successfactors.sfapi.sfobject.SFObject;
import com.successfactors.sfapi.sfobject.SFParameter;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.successfactors.SuccessFactorsConnector;
import org.mule.module.successfactors.connectivity.SuccessFactorsConnectorConnectionManager;


/**
 * UpsertMessageProcessor invokes the {@link org.mule.module.successfactors.SuccessFactorsConnector#upsert(java.lang.String, java.util.List, java.util.List)} method in {@link SuccessFactorsConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.1", date = "2012-12-18T05:44:26-03:00", comments = "Build UNNAMED.1297.150f2c9")
public class UpsertMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object type;
    protected String _typeType;
    protected Object objects;
    protected List<SFObject> _objectsType;
    protected Object processingParams;
    protected List<SFParameter> _processingParamsType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets type
     * 
     * @param value Value to set
     */
    public void setType(Object value) {
        this.type = value;
    }

    /**
     * Sets objects
     * 
     * @param value Value to set
     */
    public void setObjects(Object value) {
        this.objects = value;
    }

    /**
     * Sets processingParams
     * 
     * @param value Value to set
     */
    public void setProcessingParams(Object value) {
        this.processingParams = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        try {
            findOrCreate(SuccessFactorsConnectorConnectionManager.class, false, event);
            final String _transformedType = ((String) evaluateAndTransform(getMuleContext(), event, UpsertMessageProcessor.class.getDeclaredField("_typeType").getGenericType(), null, type));
            final List<SFObject> _transformedObjects = ((List<SFObject> ) evaluateAndTransform(getMuleContext(), event, UpsertMessageProcessor.class.getDeclaredField("_objectsType").getGenericType(), null, objects));
            final List<SFParameter> _transformedProcessingParams = ((List<SFParameter> ) evaluateAndTransform(getMuleContext(), event, UpsertMessageProcessor.class.getDeclaredField("_processingParamsType").getGenericType(), null, processingParams));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((SuccessFactorsConnector) object).upsert(_transformedType, _transformedObjects, _transformedProcessingParams);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("upsert"), event, e);
        }
    }

}
