/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.successfactors;

import com.successfactors.sfapi.sfobject.DeleteResult;
import com.successfactors.sfapi.sfobject.DescribeResult;
import com.successfactors.sfapi.sfobject.DescribeSFObjects;
import com.successfactors.sfapi.sfobject.GetJobResult;
import com.successfactors.sfapi.sfobject.InsertResult;
import com.successfactors.sfapi.sfobject.QueryResult;
import com.successfactors.sfapi.sfobject.SFObject;
import com.successfactors.sfapi.sfobject.SFParameter;
import com.successfactors.sfapi.sfobject.TaskStatus;
import com.successfactors.sfapi.sfobject.UpdateResult;
import com.successfactors.sfapi.sfobject.UpsertResult;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.module.successfactors.api.SuccessFactorsClientBase;
import org.mule.module.successfactors.api.SuccessFactorsClientImpl;
import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

@Connector(name="successfactors", schemaVersion="1.0", friendlyName="Success Factors")
public class SuccessFactorsConnector {
    private static final Log logger = LogFactory.getLog(SuccessFactorsConnector.class);
    @Configurable
    private String wsdlLocation;
    @Configurable
    private String companyId;
    private SuccessFactorsClientBase client;

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public SuccessFactorsClientBase getClient() {
        return this.client;
    }

    public void setClient(SuccessFactorsClientBase client) {
        this.client = client;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    @Connect
    public void connect(@ConnectionKey String username, String password) throws ConnectionException {
        if (this.client == null) {
            this.client = new SuccessFactorsClientImpl(this.wsdlLocation, this.companyId, username, password);
            try {
                this.client.initClient();
                this.client.login(null);
            }
            catch (SuccessFactorsConnectorException e) {
                throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", e.getMessage(), (Throwable)e);
            }
        }
    }

    @Disconnect
    public void disconnect() {
        if (this.client != null) {
            try {
                this.client.logout();
            }
            catch (SuccessFactorsConnectorException e) {
                logger.debug((Object)("Error trying to logout from Success Factors service for user " + this.client.getUsername()));
            }
            this.client.release();
            this.client = null;
        }
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.client != null;
    }

    @ConnectionIdentifier
    public String connectionId() {
        return this.client.getUsername();
    }

    @Processor
    public List<String> listEntities() throws SuccessFactorsConnectorException {
        return this.client.listEntities();
    }

    @Processor
    public List<DescribeResult> describeEntities(DescribeSFObjects params) throws SuccessFactorsConnectorException {
        return this.client.describeEntities(params);
    }

    @Processor
    public InsertResult insert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        return this.client.insert(type, objects, processingParams);
    }

    @Processor
    public UpdateResult update(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        return this.client.update(type, objects, processingParams);
    }

    @Processor
    public UpsertResult upsert(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        return this.client.upsert(type, objects, processingParams);
    }

    @Processor
    public DeleteResult delete(String type, List<SFObject> objects, List<SFParameter> processingParams) throws SuccessFactorsConnectorException {
        return this.client.delete(type, objects, processingParams);
    }

    @Processor
    public QueryResult query(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException {
        return this.client.query(queryString, params);
    }

    @Processor
    public QueryResult queryMore(String querySessionId) throws SuccessFactorsConnectorException {
        return this.client.queryMore(querySessionId);
    }

    @Processor
    public TaskStatus submitQueryJob(String queryString, List<SFParameter> params) throws SuccessFactorsConnectorException {
        return this.client.submitQueryJob(queryString, params);
    }

    @Processor
    public TaskStatus getJobStatus(String taskId) throws SuccessFactorsConnectorException {
        return this.client.getJobStatus(taskId);
    }

    @Processor
    public DataHandler getJobResult(GetJobResult params) throws SuccessFactorsConnectorException {
        return this.client.getJobResult(params);
    }

    @Processor
    public List<TaskStatus> listJobs() throws SuccessFactorsConnectorException {
        return this.client.listJobs();
    }

    @Processor
    public TaskStatus cancelJob(String taskId) throws SuccessFactorsConnectorException {
        return this.client.cancelJob(taskId);
    }
}

