/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.successfactors.api;

import com.successfactors.sfapi.server.SFAPI;
import com.successfactors.sfapi.server.SFAPIService;
import java.net.MalformedURLException;
import java.net.URL;
import org.mule.module.successfactors.api.SuccessFactorsClient;
import org.mule.module.successfactors.execptions.SuccessFactorsConnectorException;

public abstract class SuccessFactorsClientBase
implements SuccessFactorsClient {
    private static SFAPIService service;
    private static Object serviceLock;
    protected String wsdlLocation;
    protected String companyId;
    protected String username;
    protected String password;

    public SuccessFactorsClientBase(String wsdlLocation, String companyId, String username, String password) {
        this.wsdlLocation = wsdlLocation;
        this.companyId = companyId;
        this.username = username;
        this.password = password;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SFAPI getClientInstance() throws SuccessFactorsConnectorException {
        Object object = serviceLock;
        synchronized (object) {
            if (service == null) {
                try {
                    service = new SFAPIService(new URL(this.wsdlLocation));
                }
                catch (MalformedURLException e) {
                    throw new SuccessFactorsConnectorException("ERROR. Cannot create the service beacuse the wsdl URL is malformed", (Throwable)e);
                }
            }
        }
        return service.getSFAPI();
    }

    public void release() {
        this.wsdlLocation = null;
        this.companyId = null;
        this.username = null;
        this.password = null;
    }

    static {
        serviceLock = new Object();
        service = null;
    }
}

